/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.api;

import com.autodesk.client.ApiClient;
import com.autodesk.client.ApiException;
import com.autodesk.client.ApiResponse;
import com.autodesk.client.Configuration;
import com.autodesk.client.Pair;
import com.autodesk.client.auth.Authentication;
import com.autodesk.client.auth.Credentials;
import com.autodesk.client.model.Hub;
import com.autodesk.client.model.Hubs;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HubsApi {
    private ApiClient apiClient;

    public HubsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HubsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiResponse<Hub> getHub(String hubId, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (hubId == null) {
            throw new ApiException(400, "Missing the required parameter 'hubId' when calling getHub");
        }
        String localVarPath = "/project/v1/hubs/{hub_id}".replaceAll("\\{format\\}", "json").replaceAll("\\{hub_id\\}", this.apiClient.escapeString(hubId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Hub> localVarReturnType = new GenericType<Hub>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Hubs> getHubs(List<String> filterId, List<String> filterExtensionType, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        String localVarPath = "/project/v1/hubs".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[extension.type]", filterExtensionType));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Hubs> localVarReturnType = new GenericType<Hubs>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }
}

