/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.api;

import com.autodesk.client.ApiClient;
import com.autodesk.client.ApiException;
import com.autodesk.client.ApiResponse;
import com.autodesk.client.Configuration;
import com.autodesk.client.Pair;
import com.autodesk.client.auth.Authentication;
import com.autodesk.client.auth.Credentials;
import com.autodesk.client.model.Formats;
import com.autodesk.client.model.Job;
import com.autodesk.client.model.JobPayload;
import com.autodesk.client.model.Manifest;
import com.autodesk.client.model.Metadata;
import com.autodesk.client.model.Result;
import com.sun.jersey.api.client.GenericType;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class DerivativesApi {
    private ApiClient apiClient;

    public DerivativesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DerivativesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiResponse<Result> deleteManifest(String urn, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (urn == null) {
            throw new ApiException(400, "Missing the required parameter 'urn' when calling deleteManifest");
        }
        String localVarPath = "/modelderivative/v2/designdata/{urn}/manifest".replaceAll("\\{format\\}", "json").replaceAll("\\{urn\\}", this.apiClient.escapeString(urn.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Result> localVarReturnType = new GenericType<Result>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Void> getDerivativeManifest(String urn, String derivativeUrn, Integer range, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (urn == null) {
            throw new ApiException(400, "Missing the required parameter 'urn' when calling getDerivativeManifest");
        }
        if (derivativeUrn == null) {
            throw new ApiException(400, "Missing the required parameter 'derivativeUrn' when calling getDerivativeManifest");
        }
        String localVarPath = "/modelderivative/v2/designdata/{urn}/manifest/{derivativeUrn}".replaceAll("\\{format\\}", "json").replaceAll("\\{urn\\}", this.apiClient.escapeString(urn.toString())).replaceAll("\\{derivativeUrn\\}", this.apiClient.escapeString(derivativeUrn.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (range != null) {
            localVarHeaderParams.put("Range", this.apiClient.parameterToString(range));
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }

    public ApiResponse<Formats> getFormats(Date ifModifiedSince, String acceptEncoding, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        String localVarPath = "/modelderivative/v2/designdata/formats".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Formats> localVarReturnType = new GenericType<Formats>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Manifest> getManifest(String urn, String acceptEncoding, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (urn == null) {
            throw new ApiException(400, "Missing the required parameter 'urn' when calling getManifest");
        }
        String localVarPath = "/modelderivative/v2/designdata/{urn}/manifest".replaceAll("\\{format\\}", "json").replaceAll("\\{urn\\}", this.apiClient.escapeString(urn.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Manifest> localVarReturnType = new GenericType<Manifest>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Metadata> getMetadata(String urn, String acceptEncoding, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (urn == null) {
            throw new ApiException(400, "Missing the required parameter 'urn' when calling getMetadata");
        }
        String localVarPath = "/modelderivative/v2/designdata/{urn}/metadata".replaceAll("\\{format\\}", "json").replaceAll("\\{urn\\}", this.apiClient.escapeString(urn.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Metadata> localVarReturnType = new GenericType<Metadata>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Metadata> getModelviewMetadata(String urn, String guid, String acceptEncoding, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (urn == null) {
            throw new ApiException(400, "Missing the required parameter 'urn' when calling getModelviewMetadata");
        }
        if (guid == null) {
            throw new ApiException(400, "Missing the required parameter 'guid' when calling getModelviewMetadata");
        }
        String localVarPath = "/modelderivative/v2/designdata/{urn}/metadata/{guid}".replaceAll("\\{format\\}", "json").replaceAll("\\{urn\\}", this.apiClient.escapeString(urn.toString())).replaceAll("\\{guid\\}", this.apiClient.escapeString(guid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Metadata> localVarReturnType = new GenericType<Metadata>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Metadata> getModelviewProperties(String urn, String guid, String acceptEncoding, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (urn == null) {
            throw new ApiException(400, "Missing the required parameter 'urn' when calling getModelviewProperties");
        }
        if (guid == null) {
            throw new ApiException(400, "Missing the required parameter 'guid' when calling getModelviewProperties");
        }
        String localVarPath = "/modelderivative/v2/designdata/{urn}/metadata/{guid}/properties".replaceAll("\\{format\\}", "json").replaceAll("\\{urn\\}", this.apiClient.escapeString(urn.toString())).replaceAll("\\{guid\\}", this.apiClient.escapeString(guid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Metadata> localVarReturnType = new GenericType<Metadata>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<File> getThumbnail(String urn, Integer width, Integer height, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (urn == null) {
            throw new ApiException(400, "Missing the required parameter 'urn' when calling getThumbnail");
        }
        String localVarPath = "/modelderivative/v2/designdata/{urn}/thumbnail".replaceAll("\\{format\\}", "json").replaceAll("\\{urn\\}", this.apiClient.escapeString(urn.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "width", width));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "height", height));
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<File> localVarReturnType = new GenericType<File>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Job> translate(JobPayload job, Boolean xAdsForce, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        JobPayload localVarPostBody = job;
        if (job == null) {
            throw new ApiException(400, "Missing the required parameter 'job' when calling translate");
        }
        String localVarPath = "/modelderivative/v2/designdata/job".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xAdsForce != null) {
            localVarHeaderParams.put("x-ads-force", this.apiClient.parameterToString(xAdsForce));
        }
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Job> localVarReturnType = new GenericType<Job>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }
}

