/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.api;

import com.autodesk.client.ApiClient;
import com.autodesk.client.ApiException;
import com.autodesk.client.ApiResponse;
import com.autodesk.client.Configuration;
import com.autodesk.client.Pair;
import com.autodesk.client.auth.Authentication;
import com.autodesk.client.auth.Credentials;
import com.autodesk.client.model.Activity;
import com.autodesk.client.model.ActivityOptional;
import com.autodesk.client.model.ActivityVersion;
import com.autodesk.client.model.DesignAutomationActivities;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class ActivitiesApi {
    private ApiClient apiClient;

    public ActivitiesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ActivitiesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiResponse<Activity> createActivity(Activity activity, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Activity localVarPostBody = activity;
        if (activity == null) {
            throw new ApiException(400, "Missing the required parameter 'activity' when calling createActivity");
        }
        String localVarPath = "/autocad.io/us-east/v2/Activities".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Activity> localVarReturnType = new GenericType<Activity>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Void> deleteActivity(String id, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteActivity");
        }
        String localVarPath = "/autocad.io/us-east/v2/Activities('{id}')".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }

    public ApiResponse<Void> deleteActivityHistory(String id, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteActivityHistory");
        }
        String localVarPath = "/autocad.io/us-east/v2/Activities('{id}')/Operations.DeleteHistory".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }

    public ApiResponse<Activity> getActivity(String id, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getActivity");
        }
        String localVarPath = "/autocad.io/us-east/v2/Activities('{id}')".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Activity> localVarReturnType = new GenericType<Activity>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<DesignAutomationActivities> getActivityVersions(String id, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getActivityVersions");
        }
        String localVarPath = "/autocad.io/us-east/v2/Activities('{id}')/Operations.GetVersions".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<DesignAutomationActivities> localVarReturnType = new GenericType<DesignAutomationActivities>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<DesignAutomationActivities> getAllActivities(Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        String localVarPath = "/autocad.io/us-east/v2/Activities".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<DesignAutomationActivities> localVarReturnType = new GenericType<DesignAutomationActivities>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Void> patchActivity(String id, ActivityOptional activity, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        ActivityOptional localVarPostBody = activity;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling patchActivity");
        }
        if (activity == null) {
            throw new ApiException(400, "Missing the required parameter 'activity' when calling patchActivity");
        }
        String localVarPath = "/autocad.io/us-east/v2/Activities('{id}')".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }

    public ApiResponse<Void> setActivityVersion(String id, ActivityVersion activityVersion, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        ActivityVersion localVarPostBody = activityVersion;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling setActivityVersion");
        }
        if (activityVersion == null) {
            throw new ApiException(400, "Missing the required parameter 'activityVersion' when calling setActivityVersion");
        }
        String localVarPath = "/autocad.io/us-east/v2/Activities('{id}')/Operations.SetVersion".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }

    public ApiResponse<Void> updateActivity(String id, Activity activity, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Activity localVarPostBody = activity;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateActivity");
        }
        if (activity == null) {
            throw new ApiException(400, "Missing the required parameter 'activity' when calling updateActivity");
        }
        String localVarPath = "/autocad.io/us-east/v2/Activities('{id}')".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }
}

