/*
 * Decompiled with CFR 0.152.
 */
package com.authy.api;

import com.authy.AuthyException;
import com.authy.api.Error;
import com.authy.api.Formattable;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import org.json.JSONException;
import org.json.JSONObject;

public class Resource {
    private static final Logger LOGGER = Logger.getLogger(Resource.class.getName());
    public static final String METHOD_POST = "POST";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_PUT = "PUT";
    public static final String ENCODE = "UTF-8";
    public static final String XML_CONTENT_TYPE = "application/xml";
    public static final String JSON_CONTENT_TYPE = "application/json";
    private final String apiUri;
    private final String apiKey;
    private final boolean testFlag;
    private Map<String, String> defaultOptions;
    private final boolean isJSON;
    private final String contentType;

    public Resource(String uri, String key) {
        this(uri, key, false, JSON_CONTENT_TYPE);
    }

    public Resource(String uri, String key, String contentType) {
        this(uri, key, false, contentType);
    }

    public Resource(String uri, String key, boolean testFlag) {
        this(uri, key, testFlag, JSON_CONTENT_TYPE);
    }

    public Resource(String uri, String key, boolean testFlag, String contentType) {
        this.apiUri = uri;
        this.apiKey = key;
        this.testFlag = testFlag;
        this.contentType = contentType == null || contentType.equals(XML_CONTENT_TYPE) || !contentType.equals(JSON_CONTENT_TYPE) ? XML_CONTENT_TYPE : JSON_CONTENT_TYPE;
        this.isJSON = this.contentType.equals(JSON_CONTENT_TYPE);
    }

    public Response post(String path, Formattable data) throws AuthyException {
        return this.request(METHOD_POST, path, data, this.getDefaultOptions());
    }

    public Response get(String path, Formattable data) throws AuthyException {
        return this.request(METHOD_GET, path, data, this.getDefaultOptions());
    }

    public Response put(String path, Formattable data) throws AuthyException {
        return this.request(METHOD_PUT, path, data, this.getDefaultOptions());
    }

    public Response delete(String path, Formattable data) throws AuthyException {
        return this.request("DELETE", path, data, this.getDefaultOptions());
    }

    private Response request(String method, String path, Formattable data, Map<String, String> options) throws AuthyException {
        try {
            StringBuilder sb = new StringBuilder();
            if (method.equals(METHOD_GET)) {
                sb.append(this.prepareGet(data));
            }
            URL url = new URL(this.apiUri + path + sb.toString());
            HttpURLConnection connection = this.createConnection(url, method, options);
            connection.setRequestProperty("X-Authy-API-Key", this.apiKey);
            if (data != null && data.toMap().containsKey("api_key")) {
                LOGGER.log(Level.WARNING, "Found 'api_key' as a parameter, please remove it, Authy-Java already handles the'api_key' for you.");
            }
            if (method.equals(METHOD_POST) || method.equals(METHOD_PUT)) {
                if (this.isJSON) {
                    this.writeJson(connection, data);
                } else {
                    this.writeXml(connection, data);
                }
            }
            int status = connection.getResponseCode();
            return new Response(status, this.getResponse(connection, status));
        }
        catch (SSLHandshakeException e) {
            throw new AuthyException("SSL verification is failing. Contact support@authy.com", e);
        }
        catch (MalformedURLException e) {
            throw new AuthyException("Invalid host", e);
        }
        catch (IOException e) {
            throw new AuthyException("Connection error", e);
        }
    }

    Error errorFromJson(String content) throws AuthyException {
        try {
            JSONObject errorJson = new JSONObject(content);
            Error error = new Error();
            error.setMessage(errorJson.getString("message"));
            int errorCodeNumber = Integer.parseInt(errorJson.getString("error_code"));
            Error.Code error_code = Arrays.stream(Error.Code.values()).filter(code -> code.getNumber() == errorCodeNumber).findFirst().orElse(Error.Code.DEFAULT_ERROR);
            error.setCode(error_code);
            return error;
        }
        catch (NumberFormatException | JSONException e) {
            throw new AuthyException("Invalid response from server", e);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    private HttpURLConnection createConnection(URL url, String method, Map<String, String> options) throws IOException {
        HttpURLConnection connection = this.testFlag ? (HttpURLConnection)url.openConnection() : (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        for (Map.Entry<String, String> s : options.entrySet()) {
            connection.setRequestProperty(s.getKey(), s.getValue());
        }
        connection.setDoOutput(true);
        return connection;
    }

    private String getResponse(HttpURLConnection connection, int status) throws IOException {
        int ch;
        InputStream in = status != 200 ? connection.getErrorStream() : connection.getInputStream();
        BufferedInputStream input = new BufferedInputStream(in);
        StringBuilder sb = new StringBuilder();
        while ((ch = input.read()) != -1) {
            sb.append((char)ch);
        }
        input.close();
        return sb.toString();
    }

    private void writeXml(HttpURLConnection connection, Formattable data) throws IOException {
        if (data == null) {
            return;
        }
        OutputStream os = connection.getOutputStream();
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(os));
        output.write(data.toXML());
        output.flush();
        output.close();
    }

    private void writeJson(HttpURLConnection connection, Formattable data) throws IOException {
        if (data == null) {
            return;
        }
        OutputStream os = connection.getOutputStream();
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(os));
        output.write(data.toJSON());
        output.flush();
        output.close();
    }

    private String prepareGet(Formattable data) {
        if (data == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("?");
        Map<String, String> params = data.toMap();
        boolean first = true;
        for (Map.Entry<String, String> s : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append('&');
            }
            try {
                sb.append(URLEncoder.encode(s.getKey(), ENCODE)).append("=").append(URLEncoder.encode(s.getValue(), ENCODE));
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("Encoding not supported" + e.getMessage());
            }
        }
        return sb.toString();
    }

    private Map<String, String> getDefaultOptions() {
        if (this.defaultOptions == null || this.defaultOptions.isEmpty()) {
            this.defaultOptions = new HashMap<String, String>();
            this.defaultOptions.put("Content-Type", this.contentType);
            this.defaultOptions.put("User-Agent", this.getUserAgent());
        }
        return this.defaultOptions;
    }

    private String getUserAgent() {
        String os = String.format("%s-%s-%s; Java %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.specification.version"));
        return String.format("%s/%s (%s)", "AuthyJava", "1.5.0", os);
    }

    public static class Response {
        private final Integer status;
        private final String body;

        Response(Integer status, String body) {
            this.status = status;
            this.body = body;
        }

        public Integer getStatus() {
            return this.status;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            return "Response[" + this.status + ", " + this.body + "]";
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Response && Objects.equals(this.status, ((Response)o).status) && Objects.equals(this.body, ((Response)o).body);
        }

        public int hashCode() {
            return Objects.hash(this.status, this.body);
        }
    }
}

