/*
 * Decompiled with CFR 0.152.
 */
package com.authy.api;

import com.authy.AuthyException;
import com.authy.api.Error;
import com.authy.api.Formattable;
import com.authy.api.Hash;
import com.authy.api.Resource;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.json.JSONException;
import org.json.JSONObject;

public class Users
extends Resource {
    public static final String NEW_USER_PATH = "/protected/json/users/new";
    public static final String DELETE_USER_PATH = "/protected/json/users/delete/";
    public static final String SMS_PATH = "/protected/json/sms/";
    public static final String ONE_CODE_CALL_PATH = "/protected/json/call/";
    public static final String DEFAULT_COUNTRY_CODE = "1";

    public Users(String uri, String key) {
        super(uri, key, "application/json");
    }

    public Users(String uri, String key, boolean testFlag) {
        super(uri, key, testFlag, "application/json");
    }

    public com.authy.api.User createUser(String email, String phone, String countryCode) throws AuthyException {
        User user = new User(email, phone, countryCode);
        String content = this.post(NEW_USER_PATH, user);
        return this.userFromJson(this.getStatus(), content);
    }

    public com.authy.api.User createUser(String email, String phone) throws AuthyException {
        return this.createUser(email, phone, DEFAULT_COUNTRY_CODE);
    }

    public Hash requestSms(int userId) throws AuthyException {
        return this.requestSms(userId, new HashMap<String, String>(0));
    }

    public Hash requestSms(int userId, Map<String, String> options) throws AuthyException {
        MapToResponse opt = new MapToResponse(options);
        String content = this.get(SMS_PATH + Integer.toString(userId), opt);
        return this.instanceFromJson(this.getStatus(), content);
    }

    public Hash requestCall(int userId) throws AuthyException {
        return this.requestCall(userId, new HashMap<String, String>(0));
    }

    public Hash requestCall(int userId, Map<String, String> options) throws AuthyException {
        MapToResponse opt = new MapToResponse(options);
        String content = this.get(ONE_CODE_CALL_PATH + Integer.toString(userId), opt);
        return this.instanceFromJson(this.getStatus(), content);
    }

    public Hash deleteUser(int userId) throws AuthyException {
        String content = this.post(DELETE_USER_PATH + Integer.toString(userId), null);
        return this.instanceFromJson(this.getStatus(), content);
    }

    private com.authy.api.User userFromJson(int status, String content) throws AuthyException {
        com.authy.api.User user = new com.authy.api.User(status, content);
        if (user.isOk()) {
            JSONObject userJson = new JSONObject(content);
            user.setId(userJson.getJSONObject("user").getInt("id"));
        } else {
            Error error = this.errorFromJson(status, content);
            user.setError(error);
        }
        return user;
    }

    private Hash instanceFromJson(int status, String content) throws AuthyException {
        Hash hash = new Hash(status, content);
        if (hash.isOk()) {
            try {
                JSONObject jsonResponse = new JSONObject(content);
                String message = jsonResponse.optString("message");
                hash.setMessage(message);
                boolean success = jsonResponse.optBoolean("success");
                hash.setSuccess(success);
                String token = jsonResponse.optString("token");
                hash.setToken(token);
            }
            catch (JSONException e) {
                throw new AuthyException("Invalid response from server", e);
            }
        } else {
            Error error = this.errorFromJson(status, content);
            hash.setError(error);
        }
        return hash;
    }

    @XmlRootElement(name="user")
    static class User
    implements Formattable {
        String email;
        String cellphone;
        String countryCode;

        public User() {
        }

        public User(String email, String cellphone, String countryCode) {
            this.email = email;
            this.cellphone = cellphone;
            this.countryCode = countryCode;
        }

        @XmlElement(name="email")
        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        @XmlElement(name="cellphone")
        public String getCellphone() {
            return this.cellphone;
        }

        public void setCellphone(String cellphone) {
            this.cellphone = cellphone;
        }

        @XmlElement(name="country_code")
        public String getCountryCode() {
            return this.countryCode;
        }

        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public String toXML() {
            StringWriter sw = new StringWriter();
            String xml = "";
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
                Marshaller marshaller = context.createMarshaller();
                marshaller.marshal((Object)this, (Writer)sw);
                xml = sw.toString();
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
            return xml;
        }

        @Override
        public Map<String, String> toMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("email", this.email);
            map.put("cellphone", this.cellphone);
            map.put("country_code", this.countryCode);
            return map;
        }

        @Override
        public String toJSON() {
            JSONObject json = new JSONObject();
            json.put("user", this.toMap());
            return json.toString();
        }
    }

    static class MapToResponse
    implements Formattable {
        private Map<String, String> options;

        public MapToResponse(Map<String, String> options) {
            this.options = options;
        }

        @Override
        public String toXML() {
            return "";
        }

        @Override
        public Map<String, String> toMap() {
            return this.options;
        }
    }
}

