/*
 * Decompiled with CFR 0.152.
 */
package com.authy.api;

import com.authy.api.Formattable;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource {
    private String apiUri;
    private String apiKey;
    private int status;
    private boolean testFlag = false;
    private Map<String, String> defaultOptions;
    public static final String ENCODE = "UTF-8";
    public static final String XML_CONTENT_TYPE = "application/xml";
    public static final String JSON_CONTENT_TYPE = "application/json";
    private boolean isJSON = false;
    private String contentType = "application/xml";

    public Resource(String uri, String key) {
        this.apiUri = uri;
        this.apiKey = key;
    }

    public Resource(String uri, String key, String contentType) {
        this.apiUri = uri;
        this.apiKey = key;
        boolean bl = this.isJSON = contentType == "JSON";
        if (this.isJSON) {
            this.contentType = JSON_CONTENT_TYPE;
        }
    }

    public Resource(String uri, String key, boolean testFlag) {
        this.apiUri = uri;
        this.apiKey = key;
        this.testFlag = testFlag;
    }

    public Resource(String uri, String key, boolean testFlag, String contentType) {
        this.apiUri = uri;
        this.apiKey = key;
        this.testFlag = testFlag;
        boolean bl = this.isJSON = contentType == "JSON";
        if (this.isJSON) {
            this.contentType = JSON_CONTENT_TYPE;
        }
    }

    public String post(String path, Formattable data) {
        return this.request("POST", path, data, this.getDefaultOptions());
    }

    public String get(String path, Formattable data) {
        return this.request("GET", path, data, this.getDefaultOptions());
    }

    public String put(String path, Formattable data) {
        return this.request("PUT", path, data, this.getDefaultOptions());
    }

    public String delete(String path, Formattable data) {
        return this.request("DELETE", path, data, this.getDefaultOptions());
    }

    public String request(String method, String path, Formattable data, Map<String, String> options) {
        HttpURLConnection connection = null;
        String answer = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("?api_key=" + this.apiKey);
            if (method.equals("GET")) {
                sb.append(this.prepareGet(data));
            }
            URL url = new URL(this.apiUri + path + sb.toString());
            connection = this.createConnection(url, method, options);
            if (method.equals("POST") || method.equals("PUT")) {
                if (this.isJSON) {
                    this.writeJson(connection, data);
                } else {
                    this.writeXml(connection, data);
                }
            }
            this.status = connection.getResponseCode();
            answer = this.getResponse(connection);
        }
        catch (SSLHandshakeException e) {
            System.err.println("SSL verification is failing. This might be because of an attack. Contact support@authy.com");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return answer;
    }

    public int getStatus() {
        return this.status;
    }

    public String getContentType() {
        return this.contentType;
    }

    protected HttpURLConnection createConnection(URL url, String method, Map<String, String> options) throws Exception {
        HttpURLConnection connection = null;
        connection = this.testFlag ? (HttpURLConnection)url.openConnection() : (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        for (Map.Entry<String, String> s : options.entrySet()) {
            connection.setRequestProperty(s.getKey(), s.getValue());
        }
        connection.setDoOutput(true);
        return connection;
    }

    private String getResponse(HttpURLConnection connection) throws Exception {
        int ch;
        InputStream in = null;
        in = this.status != 200 ? connection.getErrorStream() : connection.getInputStream();
        BufferedInputStream input = new BufferedInputStream(in);
        StringBuffer sb = new StringBuffer();
        while ((ch = input.read()) != -1) {
            sb.append((char)ch);
        }
        input.close();
        return sb.toString();
    }

    private void writeXml(HttpURLConnection connection, Formattable data) throws SSLHandshakeException, IOException {
        if (data == null) {
            return;
        }
        OutputStream os = connection.getOutputStream();
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(os));
        output.write(data.toXML());
        output.flush();
        output.close();
    }

    private void writeJson(HttpURLConnection connection, Formattable data) throws SSLHandshakeException, IOException {
        if (data == null) {
            return;
        }
        OutputStream os = connection.getOutputStream();
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(os));
        output.write(data.toJSON());
        output.flush();
        output.close();
    }

    private String prepareGet(Formattable data) throws Exception {
        if (data == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Map<String, String> params = data.toMap();
        for (Map.Entry<String, String> s : params.entrySet()) {
            sb.append('&');
            sb.append(URLEncoder.encode(s.getKey(), ENCODE) + "=" + URLEncoder.encode(s.getValue(), ENCODE));
        }
        return sb.toString();
    }

    private Map<String, String> getDefaultOptions() {
        if (this.defaultOptions == null || this.defaultOptions.isEmpty()) {
            this.defaultOptions = new HashMap<String, String>();
            this.defaultOptions.put("Content-Type", this.contentType);
            this.defaultOptions.put("Content-Type", this.contentType);
            this.defaultOptions.put("User-Agent", this.getUserAgent());
        }
        return this.defaultOptions;
    }

    private String getUserAgent() {
        String os = String.format("%s-%s-%s; Java %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.specification.version"));
        return String.format("%s/%s (%s)", "AuthyJava", "1.1.0", os);
    }
}

