/*
 * Copyright (C) 2019 Authlete, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.authlete.common.dto;


import java.io.Serializable;
import java.net.URI;


/**
 * Named URI.
 *
 * @since 2.49
 */
public class NamedUri implements Serializable
{
    private static final long serialVersionUID = 1L;


    /**
     * The name of the URI.
     */
    private String name;


    /**
     * The value of the URI.
     */
    private URI uri;


    /**
     * Get the name of the URI.
     *
     * @return
     *         The name of the URI.
     */
    public String getName()
    {
        return name;
    }


    /**
     * Set the name of the URI.
     *
     * @param name
     *         The name of the URI.
     *
     * @return
     *         {@code this} object.
     */
    public NamedUri setName(String name)
    {
        this.name = name;

        return this;
    }


    /**
     * Get the value of the URI.
     *
     * @return
     *         The value of the URI.
     */
    public URI getUri()
    {
        return uri;
    }


    /**
     * Set the value of the URI.
     *
     * @param uri
     *         The value of the URI.
     *
     * @return
     *         {@code this} object.
     */
    public NamedUri setUri(URI uri)
    {
        this.uri = uri;

        return this;
    }
}
