/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class QueryParamUtils {
    public static String addOrReplaceInQueryParams(String queryParams, String key, String value) {
        Validate.notNull((Object)queryParams);
        Validate.notNull((Object)key);
        Validate.notNull((Object)value);
        StringBuilder builder = new StringBuilder();
        String updatedQueryParams = QueryParamUtils.removeFromQueryParams(queryParams, key);
        if (updatedQueryParams.isEmpty()) {
            builder.append(key).append("=").append(value);
        } else {
            builder.append(updatedQueryParams).append("&").append(key).append("=").append(value);
        }
        return builder.toString();
    }

    public static String parseFromQueryParams(String queryParams, String key) {
        Validate.notNull((Object)queryParams);
        Validate.notNull((Object)key);
        List params = URLEncodedUtils.parse((String)queryParams, (Charset)StandardCharsets.UTF_8);
        for (NameValuePair param : params) {
            if (!key.equals(param.getName())) continue;
            return param.getValue();
        }
        return null;
    }

    public static boolean keyInQueryParams(String queryParams, String key) {
        Validate.notNull((Object)queryParams);
        Validate.notNull((Object)key);
        List params = URLEncodedUtils.parse((String)queryParams, (Charset)StandardCharsets.UTF_8);
        for (NameValuePair param : params) {
            if (!key.equals(param.getName())) continue;
            return true;
        }
        return false;
    }

    public static String removeFromQueryParams(String queryParams, String key) {
        Validate.notNull((Object)queryParams);
        Validate.notNull((Object)key);
        List params = URLEncodedUtils.parse((String)queryParams, (Charset)StandardCharsets.UTF_8);
        ArrayList<NameValuePair> newParams = new ArrayList<NameValuePair>();
        for (NameValuePair param : params) {
            if (key.equals(param.getName())) continue;
            newParams.add(param);
        }
        String newQueryStringEncoded = URLEncodedUtils.format(newParams, (Charset)StandardCharsets.UTF_8);
        try {
            String newQueryStringDecoded = URLDecoder.decode(newQueryStringEncoded, StandardCharsets.UTF_8.toString());
            return newQueryStringDecoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Failed to decode query param " + e.getLocalizedMessage());
        }
    }
}

