/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import com.auth0.authentication.result.UserIdentity;
import com.auth0.authentication.result.UserProfile;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Auth0User
implements Principal,
Serializable {
    private static final long serialVersionUID = 2371882820082543721L;
    private final String userId;
    private final String name;
    private final String nickname;
    private final String picture;
    private final String email;
    private final boolean emailVerified;
    private final String givenName;
    private final String familyName;
    private final Map<String, Object> userMetadata;
    private final Map<String, Object> appMetadata;
    private final Date createdAt;
    private final List<UserIdentity> identities;
    private final Map<String, Object> extraInfo;
    private final List<String> roles;
    private final List<String> groups;

    public Auth0User(UserProfile userProfile) {
        this(userProfile.getId(), userProfile.getName(), userProfile.getNickname(), userProfile.getPictureURL(), userProfile.getEmail(), userProfile.isEmailVerified(), userProfile.getGivenName(), userProfile.getFamilyName(), userProfile.getCreatedAt(), userProfile.getIdentities(), userProfile.getUserMetadata(), userProfile.getAppMetadata(), userProfile.getExtraInfo());
    }

    public Auth0User(String userId, String name, String nickname, String picture, String email, boolean emailVerified, String givenName, String familyName, Date createdAt, List<UserIdentity> identities, Map<String, Object> userMetadata, Map<String, Object> appMetadata, Map<String, Object> extraInfo) {
        this.userId = userId;
        this.name = name;
        this.nickname = nickname;
        this.picture = picture;
        this.email = email;
        this.emailVerified = emailVerified;
        this.givenName = givenName;
        this.familyName = familyName;
        this.createdAt = createdAt;
        this.identities = identities != null ? new ArrayList<UserIdentity>(identities) : new ArrayList();
        this.userMetadata = userMetadata != null ? new HashMap<String, Object>(userMetadata) : new HashMap();
        this.appMetadata = appMetadata != null ? new HashMap<String, Object>(appMetadata) : new HashMap();
        this.extraInfo = extraInfo != null ? new HashMap<String, Object>(extraInfo) : new HashMap();
        this.roles = extraInfo != null && extraInfo.containsKey("roles") ? new ArrayList((List)extraInfo.get("roles")) : new ArrayList();
        this.groups = extraInfo != null && extraInfo.containsKey("groups") ? new ArrayList((List)extraInfo.get("groups")) : new ArrayList();
    }

    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPicture() {
        return this.picture;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public Date getCreatedAt() {
        return this.createdAt != null ? new Date(this.createdAt.getTime()) : null;
    }

    public List<UserIdentity> getIdentities() {
        return Collections.unmodifiableList(this.identities);
    }

    public Map<String, Object> getUserMetadata() {
        return Collections.unmodifiableMap(this.userMetadata);
    }

    public Map<String, Object> getAppMetadata() {
        return Collections.unmodifiableMap(this.appMetadata);
    }

    public Map<String, Object> getExtraInfo() {
        return Collections.unmodifiableMap(this.extraInfo);
    }

    public List<String> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public List<String> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Auth0User rhs = (Auth0User)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.userId, (Object)rhs.userId).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.userId).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("userId", (Object)this.userId).append("name", (Object)this.name).append("email", (Object)this.email).toString();
    }
}

