/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.CoseException;
import java.util.ArrayList;

public class ASN1 {
    public static final byte[] Oid_secp256r1 = new byte[]{6, 8, 42, -122, 72, -50, 61, 3, 1, 7};
    public static final byte[] Oid_secp384r1 = new byte[]{6, 5, 43, -127, 4, 0, 34};
    public static final byte[] Oid_secp521r1 = new byte[]{6, 5, 43, -127, 4, 0, 35};
    static final byte[] oid_ecPublicKey = new byte[]{6, 7, 42, -122, 72, -50, 61, 2, 1};
    private static final byte[] SequenceX = new byte[]{48};

    public static byte[] EncodeSubjectPublicKeyInfo(byte[] oid, byte[] keyBytes) throws CoseException {
        try {
            ArrayList<byte[]> xxx = new ArrayList<byte[]>();
            xxx.add(ASN1.AlgorithmIdentifier(oid_ecPublicKey, oid));
            xxx.add(new byte[]{3});
            xxx.add(ASN1.GetLength(keyBytes.length + 1));
            xxx.add(new byte[]{0});
            xxx.add(keyBytes);
            return ASN1.Sequence(xxx);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.print(e.toString());
            throw e;
        }
    }

    public static byte[] EncodePKCS8(byte[] oid, byte[] keyBytes, byte[] spki) throws CoseException {
        try {
            ArrayList<Object> xxx = new ArrayList<byte[]>();
            xxx.add(new byte[]{2, 1, 1});
            xxx.add(new byte[]{4});
            xxx.add(ASN1.GetLength(keyBytes.length));
            xxx.add(keyBytes);
            xxx.add(new byte[]{-96});
            xxx.add(ASN1.GetLength(oid.length));
            xxx.add(oid);
            if (spki != null) {
                xxx.add(new byte[]{-95});
                xxx.add(ASN1.GetLength(spki.length));
                xxx.add(spki);
            }
            byte[] ecPrivateKey = ASN1.Sequence(xxx);
            xxx = new ArrayList();
            xxx.add(new byte[]{2, 1, 0});
            xxx.add(ASN1.AlgorithmIdentifier(oid_ecPublicKey, oid));
            xxx.add(new byte[]{4});
            xxx.add(ASN1.GetLength(ecPrivateKey.length));
            xxx.add(ecPrivateKey);
            return ASN1.Sequence(xxx);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.print(e.toString());
            throw e;
        }
    }

    public static byte[] EncodeSignature(byte[] r, byte[] s) throws CoseException {
        ArrayList<byte[]> x = new ArrayList<byte[]>();
        x.add(ASN1.UnsignedInteger(r));
        x.add(ASN1.UnsignedInteger(s));
        return ASN1.Sequence(x);
    }

    private static byte[] AlgorithmIdentifier(byte[] oid, byte[] params) throws CoseException {
        ArrayList<byte[]> xxx = new ArrayList<byte[]>();
        xxx.add(oid);
        if (params != null) {
            xxx.add(params);
        }
        return ASN1.Sequence(xxx);
    }

    private static byte[] Sequence(ArrayList<byte[]> members) throws CoseException {
        byte[] y = ASN1.ToBytes(members);
        ArrayList<byte[]> x = new ArrayList<byte[]>();
        x.add(SequenceX);
        x.add(ASN1.GetLength(y.length));
        x.add(y);
        return ASN1.ToBytes(x);
    }

    private static byte[] UnsignedInteger(byte[] i) throws CoseException {
        int offset;
        int pad = 0;
        for (offset = 0; offset < i.length && i[offset] == 0; ++offset) {
        }
        if (offset == i.length) {
            return new byte[]{2, 1, 0};
        }
        if ((i[offset] & 0x80) != 0) {
            ++pad;
        }
        int length = i.length - offset;
        byte[] der = new byte[2 + length + pad];
        der[0] = 2;
        der[1] = (byte)(length + pad);
        System.arraycopy(i, offset, der, 2 + pad, length);
        return der;
    }

    private static byte[] GetLength(int x) throws CoseException {
        if (x <= 127) {
            return new byte[]{(byte)x};
        }
        if (x < 256) {
            return new byte[]{-127, (byte)x};
        }
        throw new CoseException("Error in ASN1.GetLength");
    }

    private static byte[] ToBytes(ArrayList<byte[]> x) {
        int l = 0;
        for (byte[] r : x) {
            l += r.length;
        }
        byte[] b = new byte[l];
        l = 0;
        for (byte[] r : x) {
            System.arraycopy(r, 0, b, l, r.length);
            l += r.length;
        }
        return b;
    }
}

