/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.CoseException;
import COSE.KeyKeys;
import COSE.OneKey;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9Curve;
import org.bouncycastle.asn1.x9.X9ECParameters;

public class ECPublicKey
implements java.security.interfaces.ECPublicKey {
    ECPoint point;
    String algorithm;
    ECParameterSpec ecParameterSpec;
    byte[] spkiEncoded;

    public ECPublicKey(OneKey oneKey) throws CoseException, IOException {
        ASN1ObjectIdentifier curveOID;
        byte[] rgbKey;
        X9ECParameters p = oneKey.GetCurve();
        byte[] X = oneKey.get(KeyKeys.EC2_X).GetByteString();
        if (oneKey.get(KeyKeys.EC2_Y).getType() == CBORType.Boolean) {
            rgbKey = new byte[X.length + 1];
            System.arraycopy(X, 0, rgbKey, 1, X.length);
            rgbKey[0] = (byte)(2 + (oneKey.get(KeyKeys.EC2_Y).AsBoolean() ? 1 : 0));
            org.bouncycastle.math.ec.ECPoint pubPoint = p.getCurve().decodePoint(rgbKey);
            this.point = new ECPoint(this.point.getAffineX(), this.point.getAffineY());
        } else {
            rgbKey = new byte[X.length * 2 + 1];
            System.arraycopy(X, 0, rgbKey, 1, X.length);
            byte[] Y = oneKey.get(KeyKeys.EC2_Y).GetByteString();
            System.arraycopy(Y, 0, rgbKey, 1 + X.length, X.length);
            rgbKey[0] = 4;
            this.point = new ECPoint(new BigInteger(1, X), new BigInteger(1, oneKey.get(KeyKeys.EC2_Y).GetByteString()));
        }
        this.algorithm = "EC";
        CBORObject curve = oneKey.get(KeyKeys.EC2_Curve);
        if (curve.equals(KeyKeys.EC2_P256)) {
            curveOID = SECObjectIdentifiers.secp256r1;
        } else if (curve.equals(KeyKeys.EC2_P384)) {
            curveOID = SECObjectIdentifiers.secp384r1;
        } else if (curve.equals(KeyKeys.EC2_P521)) {
            curveOID = SECObjectIdentifiers.secp521r1;
        } else {
            throw new CoseException("Unrecognized Curve");
        }
        ECFieldFp field = new ECFieldFp(p.getCurve().getField().getCharacteristic());
        EllipticCurve crv = new EllipticCurve(field, p.getCurve().getA().toBigInteger(), p.getCurve().getB().toBigInteger());
        ECPoint pt = new ECPoint(p.getG().getRawXCoord().toBigInteger(), p.getG().getRawYCoord().toBigInteger());
        this.ecParameterSpec = new ECParameterSpec(crv, pt, p.getN(), p.getH().intValue());
        AlgorithmIdentifier alg = new AlgorithmIdentifier(X9Curve.id_ecPublicKey, (ASN1Encodable)curveOID);
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(alg, rgbKey);
        this.spkiEncoded = spki.getEncoded();
    }

    @Override
    public ECPoint getW() {
        return this.point;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.spkiEncoded;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecParameterSpec;
    }
}

