/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.recovery.TxState;
import java.io.Serializable;
import java.util.Properties;
import java.util.Stack;

public abstract class AbstractCompositeTransaction
implements CompositeTransaction,
Serializable {
    private static final long serialVersionUID = 3522422565305065464L;
    protected Stack<CompositeTransaction> lineage_;
    protected String tid_;
    protected boolean serial_;
    protected Properties properties_;

    public AbstractCompositeTransaction() {
    }

    public AbstractCompositeTransaction(String tid, Stack<CompositeTransaction> lineage, boolean serial) {
        this.tid_ = tid;
        this.lineage_ = lineage;
        if (this.lineage_ == null) {
            this.lineage_ = new Stack();
            this.properties_ = new Properties();
        } else if (!this.lineage_.empty()) {
            CompositeTransaction parent = this.lineage_.peek();
            this.properties_ = parent.getProperties();
        }
        if (this.properties_ == null) {
            this.properties_ = new Properties();
        }
        this.serial_ = serial;
    }

    public String getTid() {
        return this.tid_;
    }

    public boolean isSerial() {
        return this.serial_;
    }

    public boolean isLocal() {
        return false;
    }

    public RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void registerSynchronization(Synchronization sync) throws IllegalStateException, UnsupportedOperationException, SysException {
        throw new UnsupportedOperationException();
    }

    public Stack<CompositeTransaction> getLineage() {
        return (Stack)this.lineage_.clone();
    }

    public boolean isRoot() {
        return this.lineage_ == null || this.lineage_.size() == 0;
    }

    public boolean isAncestorOf(CompositeTransaction ct) {
        return ct.isDescendantOf((CompositeTransaction)this);
    }

    public boolean isDescendantOf(CompositeTransaction ct) {
        CompositeTransaction parent = null;
        if (this.lineage_ != null && !this.lineage_.empty()) {
            parent = this.lineage_.peek();
        }
        return this.isSameTransaction(ct) || parent != null && parent.isDescendantOf(ct);
    }

    public boolean isRelatedTransaction(CompositeTransaction ct) {
        Stack lineage = null;
        lineage = this.lineage_ == null ? new Stack() : (Stack)this.lineage_.clone();
        if (lineage.empty()) {
            return this.isAncestorOf(ct);
        }
        CompositeTransaction root = null;
        while (!lineage.empty()) {
            root = (CompositeTransaction)lineage.pop();
        }
        return root.isAncestorOf(ct);
    }

    public boolean isSameTransaction(CompositeTransaction ct) {
        return this.equals(ct);
    }

    public int hashCode() {
        int ret = 0;
        ret = this.tid_ == null ? super.hashCode() : this.getTid().hashCode();
        return ret;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractCompositeTransaction)) {
            return false;
        }
        AbstractCompositeTransaction other = (AbstractCompositeTransaction)obj;
        return !(this.tid_ == null ? other.tid_ != null : !this.tid_.equals(other.tid_));
    }

    public CompositeCoordinator getCompositeCoordinator() throws SysException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void addSubTxAwareParticipant(SubTxAwareParticipant subtxaware) throws SysException, UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public CompositeTransaction createSubTransaction() throws SysException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void setSerial() throws IllegalStateException, SysException {
        throw new UnsupportedOperationException();
    }

    public Extent getExtent() {
        throw new UnsupportedOperationException();
    }

    public long getTimeout() {
        return 0L;
    }

    public void setRollbackOnly() {
        throw new UnsupportedOperationException();
    }

    public void commit() throws HeurMixedException, HeurHazardException, SysException, SecurityException, RollbackException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws IllegalStateException, SysException {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String name, String value) {
        if (this.getProperty(name) == null) {
            this.properties_.setProperty(name, value);
        }
    }

    public String getProperty(String name) {
        return this.properties_.getProperty(name);
    }

    public Properties getProperties() {
        return (Properties)this.properties_.clone();
    }

    public TxState getState() {
        throw new UnsupportedOperationException();
    }
}

