/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.dataserializable;

import com.atomikos.icatch.DataSerializable;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.LogStream;
import com.atomikos.persistence.Recoverable;
import com.atomikos.persistence.dataserializable.DataByteArrayOutputStream;
import com.atomikos.persistence.imp.AbstractLogStream;
import com.atomikos.persistence.imp.SystemLogImage;
import com.atomikos.util.VersionedFile;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Vector;

public class FileLogStream
extends AbstractLogStream
implements LogStream {
    public FileLogStream(String baseDir, String baseName) throws IOException {
        super(baseDir, baseName);
    }

    @Override
    public Vector<Recoverable> recover() throws LogException {
        if (this.corrupt_) {
            throw new LogException("Instance might be corrupted");
        }
        Vector<Recoverable> ret = new Vector<Recoverable>();
        try {
            FileInputStream f = this.file_.openLastValidVersionForReading();
            int count = 0;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("Starting read of logfile " + this.file_.getCurrentVersionFileName());
            }
            while (f.available() > 0) {
                SystemLogImage systemLogImage = new SystemLogImage();
                systemLogImage.readData(new DataInputStream(f));
                ret.addElement(systemLogImage);
                if (++count % 10 != 0) continue;
                LOGGER.logInfo(".");
            }
            LOGGER.logInfo("Done read of logfile");
        }
        catch (EOFException unexpectedEOF) {
            LOGGER.logDebug("Unexpected EOF - logfile not closed properly last time?", (Throwable)unexpectedEOF);
        }
        catch (StreamCorruptedException unexpectedEOF) {
            LOGGER.logDebug("Unexpected EOF - logfile not closed properly last time?", (Throwable)unexpectedEOF);
        }
        catch (ObjectStreamException unexpectedEOF) {
            LOGGER.logDebug("Unexpected EOF - logfile not closed properly last time?", (Throwable)unexpectedEOF);
        }
        catch (FileNotFoundException firstStart) {
        }
        catch (Exception e) {
            String msg = "Error in recover";
            LOGGER.logWarning(msg, (Throwable)e);
            throw new LogException(msg, e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCheckpoint(Enumeration elements) throws LogException {
        VersionedFile versionedFile = this.file_;
        synchronized (versionedFile) {
            this.closeOutput();
            try {
                this.output_ = this.file_.openNewVersionForWriting();
                DataByteArrayOutputStream dataByteArrayOutputStream = new DataByteArrayOutputStream();
                while (elements != null && elements.hasMoreElements()) {
                    DataSerializable next = (DataSerializable)elements.nextElement();
                    dataByteArrayOutputStream.restart();
                    next.writeData((DataOutput)dataByteArrayOutputStream);
                    this.output_.write(dataByteArrayOutputStream.getContent());
                }
                this.output_.getFD().sync();
                if (this.simulateCrash_) {
                    this.corrupt_ = true;
                    throw new LogException("Old file could not be deleted");
                }
                try {
                    this.file_.discardBackupVersion();
                }
                catch (IOException errorOnDelete) {
                    this.corrupt_ = true;
                    throw new LogException("Old file could not be deleted");
                }
            }
            catch (Exception e) {
                throw new LogException("Error during checkpointing", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushObject(Object o, boolean shouldSync) throws LogException {
        try {
            DataByteArrayOutputStream dataByteArrayOutputStream = new DataByteArrayOutputStream();
            DataSerializable oo = (DataSerializable)o;
            oo.writeData((DataOutput)dataByteArrayOutputStream);
            dataByteArrayOutputStream.close();
            VersionedFile versionedFile = this.file_;
            synchronized (versionedFile) {
                if (this.output_ != null) {
                    this.output_.write(dataByteArrayOutputStream.getContent());
                }
            }
            if (shouldSync && this.output_ != null) {
                this.output_.getFD().sync();
            }
        }
        catch (IOException e) {
            throw new LogException(e.getMessage(), e);
        }
    }
}

