/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.diagnostics.Console;
import com.atomikos.finitestates.FSM;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.finitestates.FSMImp;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.finitestates.Stateful;
import com.atomikos.finitestates.TransitionTable;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.ActiveStateHandler;
import com.atomikos.icatch.imp.CoordinatorLogImage;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.HeurHazardStateHandler;
import com.atomikos.icatch.imp.ReadOnlyParticipant;
import com.atomikos.icatch.imp.SynchToFSM;
import com.atomikos.icatch.imp.TransactionTransitionTable;
import com.atomikos.icatch.imp.thread.TaskManager;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.persistence.ObjectImage;
import com.atomikos.persistence.StateRecoverable;
import com.atomikos.timing.AlarmTimer;
import com.atomikos.timing.AlarmTimerListener;
import com.atomikos.timing.PooledAlarmTimer;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Vector;

public class CoordinatorImp
implements CompositeCoordinator,
Participant,
RecoveryCoordinator,
StateRecoverable,
AlarmTimerListener,
Stateful,
FSMPreEnterListener {
    static long DEFAULT_TIMEOUT = 150L;
    private static final int MAX_INDOUBT_TICKS = 30;
    private static final int MAX_ROLLBACK_TICKS = 30;
    private Console console_ = null;
    private int localSiblingCount_ = 0;
    private AlarmTimer timer_ = null;
    private boolean checkSiblings_ = true;
    private long maxIndoubtTicks_ = 30L;
    private long maxRollbackTicks_ = 30L;
    private String root_ = null;
    private FSM fsm_ = null;
    private boolean recoverableWhileActive_;
    private boolean heuristicCommit_ = true;
    private Vector participants_ = new Vector();
    private RecoveryCoordinator coordinator_ = null;
    private Vector tags_ = new Vector();
    private CoordinatorStateHandler stateHandler_;
    private boolean single_threaded_2pc_;

    protected CoordinatorImp(String root, boolean heuristic_commit, Console console, boolean checkorphans) {
        this.root_ = root;
        this.fsm_ = new FSMImp((Object)this, (TransitionTable)new TransactionTransitionTable(), (Object)TxState.ACTIVE);
        this.heuristicCommit_ = heuristic_commit;
        this.console_ = console;
        this.setStateHandler(new ActiveStateHandler(this));
        this.startThreads(DEFAULT_TIMEOUT, console);
        this.checkSiblings_ = checkorphans;
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.TERMINATED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_COMMITTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_ABORTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_MIXED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_HAZARD);
        this.single_threaded_2pc_ = false;
    }

    protected CoordinatorImp(String root, RecoveryCoordinator coord, Console console, boolean heuristic_commit, long timeout, boolean checkorphans, boolean single_threaded_2pc) {
        this.root_ = root;
        this.single_threaded_2pc_ = single_threaded_2pc;
        this.fsm_ = new FSMImp((Object)this, (TransitionTable)new TransactionTransitionTable(), (Object)TxState.ACTIVE);
        this.heuristicCommit_ = heuristic_commit;
        this.console_ = console;
        this.recoverableWhileActive_ = false;
        this.coordinator_ = coord;
        if (timeout > DEFAULT_TIMEOUT) {
            this.maxRollbackTicks_ = this.maxIndoubtTicks_ = timeout / DEFAULT_TIMEOUT;
        }
        this.setStateHandler(new ActiveStateHandler(this));
        this.startThreads(DEFAULT_TIMEOUT, console);
        this.checkSiblings_ = checkorphans;
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.TERMINATED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_COMMITTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_ABORTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_MIXED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_HAZARD);
    }

    public CoordinatorImp(String root, RecoveryCoordinator coord, Console console, boolean heuristic_commit, boolean checkorphans) {
        this(root, coord, console, heuristic_commit, DEFAULT_TIMEOUT, checkorphans, false);
    }

    public CoordinatorImp() {
        this.fsm_ = new FSMImp((Object)this, (TransitionTable)new TransactionTransitionTable(), (Object)TxState.ACTIVE);
        this.heuristicCommit_ = false;
        this.checkSiblings_ = true;
        this.recoverableWhileActive_ = false;
        this.single_threaded_2pc_ = false;
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.TERMINATED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_COMMITTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_ABORTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_MIXED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_HAZARD);
    }

    private void printMsg(String msg) {
        if (this.console_ != null) {
            try {
                this.console_.println(msg);
            }
            catch (IOException iOException) {}
        } else {
            Configuration.logWarning(msg);
        }
    }

    private void printMsg(String msg, int level) {
        if (this.console_ != null) {
            try {
                this.console_.println(msg, level);
            }
            catch (IOException iOException) {}
        } else {
            switch (level) {
                case 3: {
                    if (!Configuration.isDebugLoggingEnabled()) break;
                    Configuration.logDebug(msg);
                    break;
                }
                case 2: {
                    if (!Configuration.isInfoLoggingEnabled()) break;
                    Configuration.logInfo(msg);
                    break;
                }
                default: {
                    Configuration.logWarning(msg);
                }
            }
        }
    }

    boolean prefersSingleThreaded2PC() {
        return this.single_threaded_2pc_;
    }

    void setCommitted() {
        this.stateHandler_.setCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTag(HeuristicMessage tag) {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (tag != null) {
                this.tags_.addElement(tag);
            }
        }
    }

    void setStateHandler(CoordinatorStateHandler stateHandler) {
        Object state = stateHandler.getState();
        this.stateHandler_ = stateHandler;
        this.setState(state);
    }

    RecoveryCoordinator getSuperiorRecoveryCoordinator() {
        return this.coordinator_;
    }

    Vector getParticipants() {
        return this.participants_;
    }

    Console getConsole() {
        return this.console_;
    }

    boolean prefersHeuristicCommit() {
        return this.heuristicCommit_;
    }

    int getLocalSiblingCount() {
        return this.localSiblingCount_;
    }

    long getMaxIndoubtTicks() {
        return this.maxIndoubtTicks_;
    }

    long getMaxRollbackTicks() {
        return this.maxRollbackTicks_;
    }

    boolean checkSiblings() {
        return this.checkSiblings_;
    }

    public Boolean isRecoverableWhileActive() {
        return new Boolean(this.recoverableWhileActive_);
    }

    public HeuristicMessage[] getHeuristicMessages(Object heuristicState) {
        return this.stateHandler_.getHeuristicMessages(heuristicState);
    }

    public boolean isCommitted() {
        return this.stateHandler_.isCommitted();
    }

    public HeuristicMessage[] getHeuristicMessages() {
        return this.stateHandler_.getHeuristicMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] getTags() {
        HeuristicMessage[] template = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            template = new HeuristicMessage[this.tags_.size()];
            for (int i = 0; i < template.length; ++i) {
                template[i] = (HeuristicMessage)this.tags_.elementAt(i);
            }
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startThreads(long timeout, Console console) {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (this.timer_ == null) {
                this.stateHandler_.activate();
                this.timer_ = new PooledAlarmTimer(timeout);
                this.timer_.addAlarmTimerListener((AlarmTimerListener)this);
                this.submitTimer(this.timer_);
            }
        }
    }

    private void submitTimer(AlarmTimer timer) {
        TaskManager.getInstance().executeTask((Runnable)timer);
    }

    protected long getTimeOut() {
        return (this.maxRollbackTicks_ - this.stateHandler_.getRollbackTicks()) * DEFAULT_TIMEOUT;
    }

    void setState(Object state) throws IllegalStateException {
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug("Coordinator " + this.getCoordinatorId() + " entering state: " + state.toString());
        }
        this.fsm_.setState(state);
    }

    public Object getState() {
        return this.fsm_.getState();
    }

    public void addFSMEnterListener(FSMEnterListener l, Object state) {
        this.fsm_.addFSMEnterListener(l, state);
    }

    public void addFSMPreEnterListener(FSMPreEnterListener l, Object state) {
        this.fsm_.addFSMPreEnterListener(l, state);
    }

    public RecoveryCoordinator getRecoveryCoordinator() {
        return this;
    }

    public Participant getParticipant() throws UnsupportedOperationException {
        return this;
    }

    public String getCoordinatorId() {
        return this.root_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException, RollbackException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (!this.getState().equals(TxState.ACTIVE)) {
                throw new IllegalStateException(this.getCoordinatorId() + " is no longer active but in state " + this.getState().toString());
            }
            if (!this.participants_.contains(participant)) {
                this.participants_.add(participant);
            }
            this.setState(TxState.ACTIVE);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incLocalSiblingCount() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ++this.localSiblingCount_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, UnsupportedOperationException, SysException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (!this.getState().equals(TxState.ACTIVE)) {
                throw new IllegalStateException("wrong state: " + this.getState());
            }
            ReadOnlyParticipant rop = new ReadOnlyParticipant(this);
            this.addParticipant(rop);
            SynchToFSM wrapper = new SynchToFSM(sync);
            this.addFSMEnterListener(wrapper, TxState.COMMITTING);
            this.addFSMEnterListener(wrapper, TxState.ABORTING);
            this.addFSMEnterListener(wrapper, TxState.TERMINATED);
            this.addFSMEnterListener(wrapper, TxState.HEUR_MIXED);
            this.addFSMEnterListener(wrapper, TxState.HEUR_ABORTED);
            this.addFSMEnterListener(wrapper, TxState.HEUR_HAZARD);
            this.addFSMEnterListener(wrapper, TxState.HEUR_COMMITTED);
        }
    }

    public void preEnter(FSMEnterEvent event) throws IllegalStateException {
        Object state = event.getState();
        if (state.equals(TxState.TERMINATED) || state.equals(TxState.HEUR_ABORTED) || state.equals(TxState.HEUR_COMMITTED) || state.equals(TxState.HEUR_HAZARD) || state.equals(TxState.HEUR_MIXED)) {
            if (!state.equals(TxState.TERMINATED)) {
                this.printMsg("Local heuristic termination of coordinator " + this.root_ + " with state " + this.getState());
            } else {
                this.dispose();
            }
        }
    }

    public String getURI() {
        return this.getCoordinatorId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recover() throws SysException {
        boolean ret;
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug("starting recover() for coordinator: " + this.getCoordinatorId());
        }
        boolean allOK = true;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            for (Participant next : this.getParticipants()) {
                boolean recoveredParticipant;
                block9: {
                    recoveredParticipant = false;
                    try {
                        recoveredParticipant = next.recover();
                        if (!Configuration.isDebugLoggingEnabled()) break block9;
                        Configuration.logDebug("coordinator: " + this.getCoordinatorId() + "recovered participant: " + next);
                    }
                    catch (Exception e) {
                        this.printMsg("Error in recovering participant");
                        StackTraceElement[] infos = e.getStackTrace();
                        for (int i = 0; i < infos.length; ++i) {
                            this.printMsg(infos[i].toString());
                        }
                    }
                }
                allOK = allOK && recoveredParticipant;
            }
            this.stateHandler_.recover(this);
            ret = !allOK && this.getState().equals(TxState.IN_DOUBT);
        }
        this.startThreads(DEFAULT_TIMEOUT, this.console_);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug("recover() done for coordinator: " + this.getCoordinatorId());
        }
        return ret;
    }

    public void forget() {
        this.stateHandler_.forget();
    }

    public void setCascadeList(Dictionary allParticipants) throws SysException {
        this.stateHandler_.setCascadeList(allParticipants);
    }

    public void setGlobalSiblingCount(int count) {
        this.stateHandler_.setGlobalSiblingCount(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        if (this.getState().equals(TxState.PREPARING)) {
            throw new RollbackException("Recursion detected");
        }
        int ret = 1;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.prepare();
            if (ret == 0) {
                if (Configuration.isDebugLoggingEnabled()) {
                    Configuration.logDebug("prepare() of Coordinator  " + this.getCoordinatorId() + " returning READONLY");
                }
            } else if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug("prepare() of Coordinator  " + this.getCoordinatorId() + " returning YES vote");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] commit(boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        HeuristicMessage[] ret = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.commit(onePhase);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        if (this.getState().equals(TxState.ABORTING)) {
            return this.getHeuristicMessages();
        }
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            return this.stateHandler_.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] rollbackHeuristically() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        HeuristicMessage[] ret = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.rollback(true, true);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] commitHeuristically() throws HeurMixedException, SysException, HeurRollbackException, HeurHazardException, IllegalStateException, RollbackException {
        HeuristicMessage[] ret = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.commit(true, false);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean replayCompletion(Participant participant) throws IllegalStateException {
        this.printMsg("replayCompletion ( " + participant + " ) received by coordinator " + this.getCoordinatorId() + " for participant " + participant.toString(), 2);
        Boolean ret = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.replayCompletion(participant);
        }
        return ret;
    }

    protected void restore(ObjectImage image) {
        CoordinatorLogImage img = (CoordinatorLogImage)image;
        this.root_ = img.root_;
        this.participants_ = img.participants_;
        this.coordinator_ = img.coordinator_;
        this.heuristicCommit_ = img.heuristicCommit_;
        this.maxIndoubtTicks_ = img.maxInquiries_;
        this.maxRollbackTicks_ = img.maxInquiries_;
        this.recoverableWhileActive_ = img.activity_;
        if (this.recoverableWhileActive_) {
            this.checkSiblings_ = img.checkSiblings_;
            this.localSiblingCount_ = img.localSiblingCount_;
        }
        this.fsm_ = new FSMImp((Object)this, (TransitionTable)new TransactionTransitionTable(), (Object)img.state_);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.TERMINATED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_COMMITTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_ABORTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_MIXED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_HAZARD);
        this.stateHandler_ = img.stateHandler_;
        if (img.state_.equals((Object)TxState.COMMITTING) && this.stateHandler_.getState().equals(TxState.ACTIVE)) {
            HeurHazardStateHandler stateHandler = new HeurHazardStateHandler(this.stateHandler_, img.participants_);
            ((CoordinatorStateHandler)stateHandler).recover(this);
            this.setStateHandler(stateHandler);
        }
        this.single_threaded_2pc_ = img.single_threaded_2pc_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectImage getObjectImage() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            return this.getObjectImage(this.getState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectImage getObjectImage(Object state) {
        CoordinatorLogImage ret = null;
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (!this.recoverableWhileActive_ && (state.equals(TxState.ACTIVE) || this.coordinator_ == null && state.equals(TxState.IN_DOUBT))) {
                ret = null;
            } else {
                TxState imgstate = (TxState)state;
                ret = this.recoverableWhileActive_ ? new CoordinatorLogImage(this.root_, imgstate, this.participants_, this.coordinator_, this.heuristicCommit_, this.maxIndoubtTicks_, this.stateHandler_, this.localSiblingCount_, this.checkSiblings_, this.single_threaded_2pc_) : new CoordinatorLogImage(this.root_, imgstate, this.participants_, this.coordinator_, this.heuristicCommit_, this.maxIndoubtTicks_, this.stateHandler_, this.single_threaded_2pc_);
            }
        }
        return ret;
    }

    public Object[] getRecoverableStates() {
        Object[] ret = new Object[]{TxState.ACTIVE, TxState.IN_DOUBT, TxState.COMMITTING, TxState.HEUR_COMMITTED, TxState.HEUR_ABORTED, TxState.HEUR_HAZARD, TxState.HEUR_MIXED};
        return ret;
    }

    public Object[] getFinalStates() {
        Object[] ret = new Object[]{TxState.TERMINATED};
        return ret;
    }

    public Object getId() {
        return this.root_;
    }

    public void alarm(AlarmTimer timer) {
        try {
            this.stateHandler_.onTimeout();
        }
        catch (Exception e) {
            this.printMsg("Exception on timeout of coordinator " + this.root_ + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (this.timer_ != null) {
                if (Configuration.isDebugLoggingEnabled()) {
                    Configuration.logDebug("Coordinator " + this.getCoordinatorId() + " : stopping timer...");
                }
                this.timer_.stop();
            }
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug("Coordinator " + this.getCoordinatorId() + " : disposing statehandler " + this.stateHandler_.getState() + "...");
            }
            this.stateHandler_.dispose();
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug("Coordinator " + this.getCoordinatorId() + " : disposed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminate(boolean commit) throws HeurRollbackException, HeurMixedException, SysException, SecurityException, HeurCommitException, HeurHazardException, RollbackException, IllegalStateException {
        FSM fSM = this.fsm_;
        synchronized (fSM) {
            if (commit) {
                if (this.participants_.size() <= 1) {
                    this.commit(true);
                } else {
                    int prepareResult = this.prepare();
                    if (prepareResult != 0) {
                        this.commit(false);
                    }
                }
            } else {
                this.rollback();
            }
        }
    }

    public void setRecoverableWhileActive() throws UnsupportedOperationException {
        this.recoverableWhileActive_ = true;
    }
}

