/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.admin.imp;

import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.admin.AdminTransaction;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.icatch.admin.imp.LocalLogAdministratorTableModel;
import com.atomikos.icatch.admin.imp.MessageTableModel;
import com.atomikos.icatch.admin.imp.StateDescriptor;
import com.atomikos.icatch.admin.imp.StateTableModel;
import com.atomikos.persistence.LogException;
import com.atomikos.swing.ExtensionsFileFilter;
import com.atomikos.swing.PropertiesPanel;
import com.atomikos.swing.PropertiesTableModel;
import com.atomikos.swing.PropertyListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

class AdminTool
implements PropertyListener,
ListSelectionListener {
    private LogControl control_;
    private JFrame frame_;
    private LocalLogAdministratorTableModel model_;
    private Vector data_;
    private Timer timer_;
    private JFileChooser fc_;
    private PropertyListener pListener_;
    private ResourceBundle messages_ = ResourceBundle.getBundle("com.atomikos.icatch.admin.imp.AdminToolResourceBundle");

    static boolean hasDetails(int state) {
        boolean ret = false;
        switch (state) {
            case 0: {
                ret = true;
                break;
            }
            case 4: {
                ret = true;
                break;
            }
            case 3: {
                ret = true;
                break;
            }
            case 1: {
                ret = true;
                break;
            }
            case 2: {
                ret = true;
                break;
            }
            case 6: {
                ret = false;
                break;
            }
            case 5: {
                ret = false;
                break;
            }
            case 7: {
                ret = false;
                break;
            }
        }
        return ret;
    }

    static Object convertState(int state) {
        TxState ret = TxState.ACTIVE;
        switch (state) {
            case 0: {
                ret = TxState.IN_DOUBT;
                break;
            }
            case 4: {
                ret = TxState.HEUR_MIXED;
                break;
            }
            case 3: {
                ret = TxState.HEUR_HAZARD;
                break;
            }
            case 1: {
                ret = TxState.HEUR_COMMITTED;
                break;
            }
            case 2: {
                ret = TxState.HEUR_ABORTED;
                break;
            }
            case 6: {
                ret = TxState.COMMITTING;
                break;
            }
            case 5: {
                ret = TxState.ABORTING;
                break;
            }
            case 7: {
                ret = TxState.TERMINATED;
                break;
            }
        }
        return ret;
    }

    private static StateDescriptor getStateDescriptor(AdminTransaction tx, int heuristicState) {
        Object state = AdminTool.convertState(heuristicState);
        HeuristicMessage[] msgs = tx.getHeuristicMessages(heuristicState);
        return new StateDescriptor(state, msgs);
    }

    private static Vector getStateDescriptors(Object admintx) {
        AdminTransaction tx = (AdminTransaction)admintx;
        Vector<StateDescriptor> ret = new Vector<StateDescriptor>();
        StateDescriptor desc = null;
        desc = AdminTool.getStateDescriptor(tx, 4);
        if (desc.messages != null && desc.messages.length != 0) {
            ret.addElement(desc);
        }
        desc = AdminTool.getStateDescriptor(tx, 3);
        if (desc.messages != null && desc.messages.length != 0) {
            ret.addElement(desc);
        }
        desc = AdminTool.getStateDescriptor(tx, 1);
        if (desc.messages != null && desc.messages.length != 0) {
            ret.addElement(desc);
        }
        desc = AdminTool.getStateDescriptor(tx, 2);
        if (desc.messages != null && desc.messages.length != 0) {
            ret.addElement(desc);
        }
        desc = AdminTool.getStateDescriptor(tx, 7);
        if (desc.messages != null && desc.messages.length != 0) {
            ret.addElement(desc);
        }
        return ret;
    }

    private static JPanel getMessagePanel(HeuristicMessage[] msgs) {
        MessageTableModel model = new MessageTableModel(msgs);
        JTable table = new JTable(model);
        table.setPreferredScrollableViewportSize(new Dimension(300, 70));
        JScrollPane scrollPane = new JScrollPane(table);
        JPanel ret = new JPanel();
        ret.setLayout(new BorderLayout());
        ret.add((Component)scrollPane, "Center");
        return ret;
    }

    AdminTool(LogControl control) {
        this.frame_ = new JFrame(this.messages_.getString("adminToolTitle"));
        this.control_ = control;
        this.timer_ = new Timer(7000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdminTool.this.model_.refresh();
            }
        });
        this.timer_.start();
        this.init();
    }

    private void init() {
        JTable table = null;
        try {
            table = this.getJTable();
        }
        catch (LogException e) {
            throw new RuntimeException(e.getMessage());
        }
        JScrollPane scrollPane = new JScrollPane(table);
        File tmpfile = new File("archive.txt");
        try {
            tmpfile.createNewFile();
        }
        catch (IOException io) {
            // empty catch block
        }
        this.fc_ = new JFileChooser(tmpfile);
        String[] extensions = new String[]{"txt"};
        this.fc_.setFileFilter((FileFilter)new ExtensionsFileFilter(extensions));
        this.fc_.setDialogTitle(this.messages_.getString("appendDialogTitle"));
        this.fc_.setFileSelectionMode(0);
        this.frame_.getContentPane().add((Component)scrollPane, "Center");
        this.frame_.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (AdminTool.this.timer_ != null) {
                    AdminTool.this.timer_.stop();
                }
            }
        });
        this.frame_.pack();
        this.frame_.setVisible(true);
        this.pListener_ = this;
    }

    private void forget(Object part, int row) {
        AdminTransaction p = (AdminTransaction)part;
        p.forceForget();
        this.model_.rowDeleted(row);
    }

    private void commit(Object part, int row) {
        try {
            AdminTransaction p = (AdminTransaction)part;
            p.forceCommit();
            this.model_.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void rollback(Object part, int row) {
        try {
            AdminTransaction p = (AdminTransaction)part;
            p.forceRollback();
            this.model_.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getHeuristicDetails(AdminTransaction p, int heuristicState) {
        StringBuffer ret = new StringBuffer();
        HeuristicMessage[] msgs = p.getHeuristicMessages(heuristicState);
        for (int i = 0; i < msgs.length; ++i) {
            if (i == 0) {
                ret.append(AdminTool.convertState(heuristicState) + ": ");
            }
            ret.append(msgs[i]);
            if (i >= msgs.length - 1) continue;
            ret.append(" -- ");
        }
        return ret.toString();
    }

    private String getMessages(Object part) {
        HeuristicMessage[] msgs = null;
        StringBuffer ret = new StringBuffer();
        AdminTransaction p = (AdminTransaction)part;
        Object state = AdminTool.convertState(p.getState());
        msgs = p.getHeuristicMessages();
        if (p.wasCommitted()) {
            ret.append(this.messages_.getString("commitAttemptedMessage"));
        } else if (p.getState() != 0) {
            ret.append(this.messages_.getString("rollbackAttemptedMessage"));
        }
        for (int i = 0; i < msgs.length; ++i) {
            ret.append(msgs[i]);
            if (i >= msgs.length - 1) continue;
            ret.append(" -- ");
        }
        if (p.getState() == 4 || p.getState() == 3) {
            ret.append(this.messages_.getString("ofWhichMessage"));
            ret.append(this.getHeuristicDetails(p, 1));
            ret.append(this.getHeuristicDetails(p, 2));
            ret.append(this.getHeuristicDetails(p, 4));
            ret.append(this.getHeuristicDetails(p, 3));
        }
        return ret.toString();
    }

    private JTable getJTable() throws LogException {
        JTable table = null;
        Vector<AdminTransaction> coordinators = new Vector<AdminTransaction>();
        AdminTransaction[] txs = this.control_.getAdminTransactions();
        if (txs != null && txs.length > 0) {
            for (int i = 0; i < txs.length; ++i) {
                coordinators.addElement(txs[i]);
            }
        }
        this.data_ = coordinators;
        LocalLogAdministratorTableModel model = new LocalLogAdministratorTableModel(coordinators);
        table = new JTable(model);
        table.setSelectionMode(0);
        this.model_ = model;
        ListSelectionModel rowSM = table.getSelectionModel();
        rowSM.addListSelectionListener(this);
        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        return table;
    }

    public void valueChanged(ListSelectionEvent e) {
        this.processEvent(e);
    }

    void processEvent(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        try {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selectedRow = lsm.getMinSelectionIndex();
                AdminTransaction rec = (AdminTransaction)this.data_.elementAt(selectedRow);
                String id = null;
                Object state = null;
                id = rec.getTid();
                state = AdminTool.convertState(rec.getState());
                if (!state.equals(TxState.IN_DOUBT)) {
                    if (AdminTool.hasDetails(rec.getState())) {
                        Object[] options = new Object[]{this.messages_.getString("forgetNoArchiveOption"), this.messages_.getString("forgetAndArchiveOption"), this.messages_.getString("keepInLogOption")};
                        Vector descriptors = AdminTool.getStateDescriptors(rec);
                        StateTableModel table = new StateTableModel(descriptors);
                        PropertiesPanel panel = new PropertiesPanel((PropertiesTableModel)table, true);
                        String outcome = null;
                        outcome = rec.wasCommitted() ? this.messages_.getString("commitOutcomeMessage") : this.messages_.getString("rollbackOutcomeMessage");
                        panel.addPropertyListener(this.pListener_);
                        int n = JOptionPane.showOptionDialog(this.frame_, panel.getPanel(), outcome + id.toString(), 1, 3, null, options, options[2]);
                        if (n == 0 || n == 1) {
                            if (n == 1) {
                                this.fc_.setDialogTitle(this.messages_.getString("appendDialogTitle"));
                                int ret = this.fc_.showOpenDialog(this.frame_);
                                if (ret == 0) {
                                    try {
                                        File file = this.fc_.getSelectedFile();
                                        FileWriter writer = new FileWriter(file.getPath(), true);
                                        writer.write(this.messages_.getString("rootTransactionMessage") + id.toString() + " ");
                                        writer.write(this.getMessages(this.data_.elementAt(selectedRow)));
                                        writer.write("\r");
                                        writer.flush();
                                        writer.close();
                                        this.forget(this.data_.elementAt(selectedRow), selectedRow);
                                    }
                                    catch (Exception err) {
                                        err.printStackTrace();
                                    }
                                }
                            } else {
                                this.forget(this.data_.elementAt(selectedRow), selectedRow);
                            }
                        } else {
                            lsm.removeSelectionInterval(selectedRow, selectedRow);
                        }
                    } else {
                        String message = this.messages_.getString("noDetailsAvailableMessage");
                        String title = this.messages_.getString("noDetailsAvailableTitle");
                        JOptionPane.showMessageDialog(this.frame_, message, title, 1);
                    }
                } else {
                    Object[] options = new Object[]{this.messages_.getString("commitOption"), this.messages_.getString("rollbackOption"), this.messages_.getString("keepInLogOption")};
                    AdminTransaction tx = (AdminTransaction)this.data_.elementAt(selectedRow);
                    JPanel panel = AdminTool.getMessagePanel(tx.getHeuristicMessages());
                    int n = JOptionPane.showOptionDialog(this.frame_, panel, this.messages_.getString("selectedTransactionMessage") + id.toString(), 1, 3, null, options, options[2]);
                    if (n == 0) {
                        this.commit(this.data_.elementAt(selectedRow), selectedRow);
                    } else if (n == 1) {
                        this.rollback(this.data_.elementAt(selectedRow), selectedRow);
                    }
                    lsm.removeSelectionInterval(selectedRow, selectedRow);
                }
                lsm.clearSelection();
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void newProperty(PropertiesTableModel model) {
        throw new RuntimeException("Should not be called");
    }

    public void deleteProperty(PropertiesTableModel model, int index) {
        throw new RuntimeException("Should not be called");
    }

    public void editProperty(PropertiesTableModel model, int index) {
        Vector data = ((StateTableModel)model).getData();
        StateDescriptor desc = (StateDescriptor)data.elementAt(index);
        JPanel panel = AdminTool.getMessagePanel(desc.messages);
        int answer = JOptionPane.showConfirmDialog(this.frame_, panel, this.messages_.getString("stateDetailsTitle"), -1);
    }
}

