/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionControl;
import java.io.Serializable;
import java.util.Properties;
import java.util.Stack;

public abstract class AbstractCompositeTransaction
implements CompositeTransaction,
Serializable {
    protected Stack lineage_;
    protected String tid_;
    protected boolean serial_;
    protected HeuristicMessage tag_;
    protected Properties properties_;

    private static void fail() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This functionality is not available for this instance");
    }

    public AbstractCompositeTransaction() {
    }

    public AbstractCompositeTransaction(String tid, Stack lineage, boolean serial) {
        this.tid_ = tid;
        this.lineage_ = lineage;
        if (this.lineage_ == null) {
            this.lineage_ = new Stack();
            this.properties_ = new Properties();
        } else if (!this.lineage_.empty()) {
            CompositeTransaction parent = (CompositeTransaction)this.lineage_.peek();
            this.properties_ = parent.getProperties();
        }
        if (this.properties_ == null) {
            this.properties_ = new Properties();
        }
        this.serial_ = serial;
    }

    public String getTid() {
        return this.tid_;
    }

    public void setTag(HeuristicMessage tag) {
        this.tag_ = tag;
    }

    public boolean isSerial() {
        return this.serial_;
    }

    public boolean isLocal() {
        return false;
    }

    public TransactionControl getTransactionControl() throws UnsupportedOperationException {
        return null;
    }

    public RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException {
        throw new UnsupportedOperationException("addParticipant");
    }

    public void registerSynchronization(Synchronization sync) throws IllegalStateException, UnsupportedOperationException, SysException {
        throw new UnsupportedOperationException("registerSynchronization");
    }

    public Stack getLineage() {
        return (Stack)this.lineage_.clone();
    }

    public boolean isRoot() {
        return this.lineage_ == null || this.lineage_.size() == 0;
    }

    public boolean isAncestorOf(CompositeTransaction ct) {
        return ct.isDescendantOf((CompositeTransaction)this);
    }

    public boolean isDescendantOf(CompositeTransaction ct) {
        CompositeTransaction parent = null;
        if (this.lineage_ != null && !this.lineage_.empty()) {
            parent = (CompositeTransaction)this.lineage_.peek();
        }
        return this.isSameTransaction(ct) || parent != null && parent.isDescendantOf(ct);
    }

    public boolean isRelatedTransaction(CompositeTransaction ct) {
        Stack lineage = null;
        lineage = this.lineage_ == null ? new Stack() : (Stack)this.lineage_.clone();
        if (lineage.empty()) {
            return this.isAncestorOf(ct);
        }
        CompositeTransaction root = null;
        while (!lineage.empty()) {
            root = (CompositeTransaction)lineage.pop();
        }
        return root.isAncestorOf(ct);
    }

    public boolean isSameTransaction(CompositeTransaction ct) {
        return this.equals(ct);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompositeTransaction)) {
            return false;
        }
        CompositeTransaction ct = (CompositeTransaction)o;
        return ct.getTid().intern().equals(this.getTid().intern());
    }

    public int hashCode() {
        int ret = 0;
        ret = this.getTid() == null ? super.hashCode() : this.getTid().hashCode();
        return ret;
    }

    public CompositeCoordinator getCompositeCoordinator() throws SysException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented: class for testing ");
    }

    public void addSubTxAwareParticipant(SubTxAwareParticipant subtxaware) throws SysException, UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("addSubTxAwareParticipant");
    }

    public CompositeTransaction createSubTransaction() throws SysException, IllegalStateException {
        AbstractCompositeTransaction.fail();
        return null;
    }

    public void setSerial() throws IllegalStateException, SysException {
        AbstractCompositeTransaction.fail();
    }

    public int getLocalSubTxCount() {
        return 0;
    }

    public Extent getExtent() {
        AbstractCompositeTransaction.fail();
        return null;
    }

    public long getTimeout() {
        AbstractCompositeTransaction.fail();
        return 0L;
    }

    public void setRollbackOnly() {
        AbstractCompositeTransaction.fail();
    }

    public void commit() throws HeurRollbackException, HeurMixedException, HeurHazardException, SysException, SecurityException, RollbackException {
        AbstractCompositeTransaction.fail();
    }

    public void rollback() throws IllegalStateException, SysException {
        AbstractCompositeTransaction.fail();
    }

    public void setProperty(String name, String value) {
        if (this.getProperty(name) == null) {
            this.properties_.setProperty(name, value);
        }
    }

    public String getProperty(String name) {
        return this.properties_.getProperty(name);
    }

    public Properties getProperties() {
        return (Properties)this.properties_.clone();
    }

    public Object getState() {
        throw new UnsupportedOperationException("getState");
    }
}

