/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp.thread;

import com.atomikos.icatch.imp.thread.ExecutorFactory;
import com.atomikos.icatch.imp.thread.InternalSystemExecutor;
import com.atomikos.icatch.imp.thread.ThreadFactory;
import com.atomikos.icatch.system.Configuration;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class Java15ExecutorFactory
implements ExecutorFactory {
    public static final String MAIN_CLASS = "java.util.concurrent.ThreadPoolExecutor";
    public static final String IQUEUE_CLASS = "java.util.concurrent.BlockingQueue";
    public static final String QUEUE_CLASS = "java.util.concurrent.SynchronousQueue";
    public static final String TIMEUNIT_CLASS = "java.util.concurrent.TimeUnit";
    public static final String IFACTORY_CLASS = "java.util.concurrent.ThreadFactory";
    private Class mainClass;
    private Constructor constructor;
    private Method submit;
    private Method shutdown;
    static /* synthetic */ Class class$java$lang$Runnable;

    protected Java15ExecutorFactory() throws Exception {
        this.checkInit();
    }

    public InternalSystemExecutor createExecutor() throws Exception {
        Object[] objectArray = this.toConstructionParameters();
        return new Executor(this.constructor.newInstance(objectArray), this.submit, this.shutdown);
    }

    protected Object[] toConstructionParameters() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Object object = Proxy.newProxyInstance(classLoader, new Class[]{this.loadClass(IFACTORY_CLASS)}, (InvocationHandler)new FactoryProxy());
        Object t = this.loadClass(QUEUE_CLASS).newInstance();
        return new Object[]{new Integer(0), new Integer(Integer.MAX_VALUE), new Long(60L), this.getSecondTimeUnit(), t, object};
    }

    protected Constructor extractConstructor(Class clazz) throws Exception {
        return clazz.getConstructor(Integer.TYPE, Integer.TYPE, Long.TYPE, this.loadClass(TIMEUNIT_CLASS), this.loadClass(IQUEUE_CLASS), this.loadClass(IFACTORY_CLASS));
    }

    protected Class loadClass(String string) throws Exception {
        Class clazz = null;
        clazz = this.safeLoad(string);
        if (clazz == null) {
            clazz = this.safeContextLoad(string);
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class '" + string + "' not found");
        }
        return clazz;
    }

    protected Class loadMainPoolClass() throws Exception {
        return this.loadClass(MAIN_CLASS);
    }

    protected Method extractSubmitMethod(Class clazz) throws Exception {
        return clazz.getMethod("execute", class$java$lang$Runnable == null ? (class$java$lang$Runnable = Java15ExecutorFactory.class$("java.lang.Runnable")) : class$java$lang$Runnable);
    }

    protected Method extractShutdownMethod(Class clazz) throws Exception {
        return clazz.getMethod("shutdown", new Class[0]);
    }

    private Class safeLoad(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private Class safeContextLoad(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader == null ? null : classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private Object getSecondTimeUnit() throws Exception {
        Class clazz = this.loadClass(TIMEUNIT_CLASS);
        Class<?> clazz2 = clazz.getClass();
        Method method = clazz2.getMethod("getEnumConstants", null);
        Object object = method.invoke((Object)clazz, null);
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (!object2.toString().equals("SECONDS")) continue;
            return object2;
        }
        return null;
    }

    private synchronized void checkInit() throws Exception {
        if (this.mainClass != null) {
            return;
        }
        this.mainClass = this.loadMainPoolClass();
        this.constructor = this.extractConstructor(this.mainClass);
        this.submit = this.extractSubmitMethod(this.mainClass);
        this.shutdown = this.extractShutdownMethod(this.mainClass);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final class FactoryProxy
    implements InvocationHandler {
        protected FactoryProxy() {
        }

        public synchronized Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            return ThreadFactory.getInstance().newThread((Runnable)objectArray[0]);
        }
    }

    private static final class Executor
    implements InternalSystemExecutor {
        private final Method submit;
        private final Method shutdown;
        private final Object target;

        private Executor(Object object, Method method, Method method2) {
            this.target = object;
            this.submit = method;
            this.shutdown = method2;
        }

        public void shutdown() {
            try {
                this.shutdown.invoke(this.target, new Object[0]);
            }
            catch (Exception exception) {
                Configuration.logWarning("Failed to shutdown 1.5 concurrent thread pool", exception);
            }
        }

        public void execute(Runnable runnable) {
            try {
                Configuration.logDebug("(1.5) executing task: " + runnable);
                this.submit.invoke(this.target, runnable);
            }
            catch (Exception exception) {
                Configuration.logWarning("Failed to invoke 1.5 concurrent thread pool", exception);
            }
        }
    }
}

