/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.admin.jmx;

import com.atomikos.icatch.admin.AdminTransaction;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.icatch.admin.jmx.JmxDefaultTransaction;
import com.atomikos.icatch.admin.jmx.JmxHeuristicTransaction;
import com.atomikos.icatch.admin.jmx.JmxLogAdministrator;
import com.atomikos.icatch.admin.jmx.JmxPreparedTransaction;
import com.atomikos.icatch.admin.jmx.JmxTransaction;
import com.atomikos.icatch.admin.jmx.JmxTransactionServiceMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxTransactionService
implements JmxTransactionServiceMBean,
MBeanRegistration {
    private MBeanServer server;
    private ObjectName[] beans;

    private JmxTransaction createMBean(AdminTransaction adminTransaction) {
        JmxTransaction jmxTransaction = null;
        switch (adminTransaction.getState()) {
            case 0: {
                jmxTransaction = new JmxPreparedTransaction(adminTransaction);
                break;
            }
            case 2: {
                jmxTransaction = new JmxHeuristicTransaction(adminTransaction);
                break;
            }
            case 1: {
                jmxTransaction = new JmxHeuristicTransaction(adminTransaction);
                break;
            }
            case 3: {
                jmxTransaction = new JmxHeuristicTransaction(adminTransaction);
                break;
            }
            case 4: {
                jmxTransaction = new JmxHeuristicTransaction(adminTransaction);
                break;
            }
            default: {
                jmxTransaction = new JmxDefaultTransaction(adminTransaction);
            }
        }
        return jmxTransaction;
    }

    private synchronized void unregisterBeans() {
        try {
            if (this.beans != null) {
                for (int i = 0; i < this.beans.length; ++i) {
                    if (!this.server.isRegistered(this.beans[i])) continue;
                    this.server.unregisterMBean(this.beans[i]);
                }
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RuntimeException(instanceNotFoundException.getMessage());
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new RuntimeException(mBeanRegistrationException.getMessage());
        }
        this.beans = null;
    }

    public synchronized ObjectName[] getTransactions() {
        this.unregisterBeans();
        LogControl logControl = JmxLogAdministrator.getInstance().getLogControl();
        if (logControl == null) {
            throw new RuntimeException("LogControl is null: transaction service not running?");
        }
        AdminTransaction[] adminTransactionArray = logControl.getAdminTransactions();
        this.beans = new ObjectName[adminTransactionArray.length];
        for (int i = 0; i < adminTransactionArray.length; ++i) {
            try {
                this.beans[i] = new ObjectName("atomikos.transactions", "TID", adminTransactionArray[i].getTid());
                JmxTransaction jmxTransaction = this.createMBean(adminTransactionArray[i]);
                this.server.registerMBean(jmxTransaction, this.beans[i]);
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        return this.beans;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.server = mBeanServer;
        if (objectName == null) {
            objectName = new ObjectName("atomikos", "name", "TransactionService");
        }
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

