/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch;

public enum TxState {
    MARKED_ABORT(false, false, new TxState[0]),
    LOCALLY_DONE(false, false, new TxState[0]),
    COMMITTED(false, false, new TxState[0]),
    ABORTED(false, false, new TxState[0]),
    ABANDONED(false, false, new TxState[0]),
    TERMINATED(true, true, new TxState[0]),
    HEUR_HAZARD("HEURISTIC HAZARD", false, false, TERMINATED),
    HEUR_COMMITTED("HEURISTIC COMMIT", true, false, TERMINATED),
    HEUR_ABORTED("HEURISTIC ROLLBACK", true, false, TERMINATED),
    HEUR_MIXED("HEURISTIC MIXED", true, false, TERMINATED),
    COMMITTING(true, false, HEUR_ABORTED, HEUR_COMMITTED, HEUR_HAZARD, HEUR_MIXED, TERMINATED),
    ABORTING("ROLLING BACK", false, false, HEUR_ABORTED, HEUR_COMMITTED, HEUR_HAZARD, HEUR_MIXED, TERMINATED),
    IN_DOUBT("PREPARED", true, false, ABORTING, COMMITTING, TERMINATED),
    PREPARING(false, false, IN_DOUBT, ABORTING, TERMINATED),
    ACTIVE(false, false, ABORTING, COMMITTING, PREPARING);

    private String label;
    private boolean recoverableState;
    private boolean finalState;
    private TxState[] legalNextStates;

    private TxState(boolean recoverableState, boolean finalState, TxState ... legalNextStates) {
        this.label = this.name();
        this.finalState = finalState;
        this.recoverableState = recoverableState;
        this.legalNextStates = legalNextStates;
    }

    private TxState(String label, boolean recoverableState, boolean finalState, TxState ... legalNextStates) {
        this.label = label;
        this.finalState = finalState;
        this.recoverableState = recoverableState;
        this.legalNextStates = legalNextStates;
    }

    public boolean isFinalState() {
        return this.finalState;
    }

    public boolean isFinalStateForOltp() {
        return this.isFinalState() || this == ABANDONED || this.isHeuristic();
    }

    public boolean isRecoverableState() {
        return this.recoverableState;
    }

    public boolean transitionAllowedTo(TxState nextState) {
        if (nextState == this) {
            return true;
        }
        for (TxState txState : this.legalNextStates) {
            if (txState != nextState) continue;
            return true;
        }
        return false;
    }

    public boolean isOneOf(TxState ... state) {
        for (int i = 0; i < state.length; ++i) {
            if (this != state[i]) continue;
            return true;
        }
        return false;
    }

    public String label() {
        return this.label;
    }

    public boolean isHeuristic() {
        return this.isOneOf(HEUR_ABORTED, HEUR_COMMITTED, HEUR_HAZARD, HEUR_MIXED);
    }
}

