/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.List;

public class ClassLoadingHelper {
    private static final Logger LOGGER = LoggerFactory.createLogger(ClassLoadingHelper.class);

    private static Object newProxyInstance(List classLoadersToTry, Class[] interfaces, InvocationHandler delegate) throws IllegalArgumentException {
        Object ret = null;
        ClassLoader cl = (ClassLoader)classLoadersToTry.get(0);
        List remainingClassLoaders = classLoadersToTry.subList(1, classLoadersToTry.size());
        try {
            return Proxy.newProxyInstance(cl, interfaces, delegate);
        }
        catch (IllegalArgumentException someClassNotFound) {
            if (remainingClassLoaders.size() <= 0) {
                throw someClassNotFound;
            }
            ret = ClassLoadingHelper.newProxyInstance(remainingClassLoaders, interfaces, delegate);
            return ret;
        }
    }

    public static Object newProxyInstance(List classLoadersToTry, Class[] minimumSetOfInterfaces, Class[] interfaces, InvocationHandler delegate) throws IllegalArgumentException {
        Object ret = null;
        try {
            ret = ClassLoadingHelper.newProxyInstance(classLoadersToTry, interfaces, delegate);
        }
        catch (IllegalArgumentException someClassNotFound) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("could not create Atomikos proxy with all requested interfaces - trying again with minimum set of interfaces");
            }
            ret = ClassLoadingHelper.newProxyInstance(classLoadersToTry, minimumSetOfInterfaces, delegate);
        }
        return ret;
    }

    public static <T> Class<T> loadClass(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException nf) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    public static URL loadResourceFromClasspath(Class<?> clazz, String resourceName) {
        URL ret = null;
        ret = clazz.getResource(resourceName);
        if (ret == null) {
            ret = clazz.getResource("/" + resourceName);
        }
        return ret;
    }

    public static Object newInstance(String className) {
        try {
            Class clazz = ClassLoadingHelper.loadClass(className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOGGER.logWarning("Unable to instanciate " + className, e);
        }
        catch (InstantiationException e) {
            LOGGER.logWarning("Unable to instanciate " + className, e);
        }
        catch (IllegalAccessException e) {
            LOGGER.logWarning("Unable to instanciate " + className, e);
        }
        return null;
    }
}

