/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

public class UniqueIdMgr {
    private static final int MAX_LENGTH_OF_NUMERIC_SUFFIX = 13;
    private static final int MAX_COUNTER_WITHIN_SAME_MILLIS = 32000;
    String server_;
    int lastcounter_;

    public UniqueIdMgr(String server) {
        this.server_ = server;
        this.lastcounter_ = 0;
    }

    private String getCountWithLeadingZeroes(int number) {
        String ret = Long.toString(number);
        int max = Long.toString(32000L).length();
        StringBuffer zeroes = new StringBuffer();
        for (int len = ret.length(); len < max; ++len) {
            zeroes.append("0");
        }
        ret = zeroes.append(ret).toString();
        return ret;
    }

    public synchronized String get() {
        ++this.lastcounter_;
        if (this.lastcounter_ == 32000) {
            this.lastcounter_ = 0;
        }
        return this.getCommonPartOfId() + System.currentTimeMillis() + this.getCountWithLeadingZeroes(this.lastcounter_);
    }

    private String getCommonPartOfId() {
        StringBuffer ret = new StringBuffer(64);
        ret.append(this.server_);
        return ret.toString();
    }

    public int getMaxIdLengthInBytes() {
        return this.getCommonPartOfId().getBytes().length + 13;
    }
}

