/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class IOHelper {
    public static void copyBytes(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int read = in.read(buffer);
        while (read >= 0) {
            out.write(buffer, 0, read);
            read = in.read(buffer);
        }
    }

    public static String getRelativePath(File fromFolder, File toFile) throws IOException {
        String basePath = fromFolder.getAbsolutePath();
        String filePath = toFile.getAbsolutePath();
        if (!filePath.startsWith(basePath)) {
            throw new IOException("The specified file is not within the folder.");
        }
        return filePath.substring(basePath.length() + 1);
    }

    public static String getDifferencePath(File fromFolder, File toFile) throws IOException {
        String commonParentPath = fromFolder.getParentFile().getAbsolutePath();
        String filePath = toFile.getAbsolutePath();
        if (!filePath.startsWith(commonParentPath)) {
            throw new IOException("The file should be contained in the parent directory of the stage folder.");
        }
        return filePath.substring(commonParentPath.length() + 1);
    }

    public static boolean createPathTo(File file, boolean isDirectory) throws IOException {
        boolean ret = false;
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            IOHelper.createPathTo(parent, true);
        }
        ret = isDirectory ? file.mkdir() : file.createNewFile();
        return ret;
    }

    public static boolean deleteContents(File folder) throws IOException {
        boolean deleted = true;
        if (!folder.isDirectory()) {
            throw new IOException("Not a directory");
        }
        File[] contents = folder.listFiles();
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i].isDirectory()) {
                if (IOHelper.deleteContents(contents[i])) continue;
                deleted = false;
                continue;
            }
            if (contents[i].delete()) continue;
            deleted = false;
        }
        return deleted;
    }

    public static byte[] readBytesFromUrl(URL url) throws IOException {
        InputStream in = url.openStream();
        byte[] ret = IOHelper.readAllBytesFromInputStream(in);
        in.close();
        return ret;
    }

    public static byte[] readAllBytesFromInputStream(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int b = in.read();
        while (b >= 0) {
            bout.write(b);
            b = in.read();
        }
        return bout.toByteArray();
    }
}

