/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.IndexedProperty;
import com.atomikos.beans.PropertyException;
import com.atomikos.beans.PropertyImp;
import com.atomikos.beans.ReadOnlyException;
import java.beans.IndexedPropertyDescriptor;
import java.lang.reflect.Method;

class IndexedPropertyImp
extends PropertyImp
implements IndexedProperty {
    private IndexedPropertyDescriptor descriptor_;

    IndexedPropertyImp(Object bean, IndexedPropertyDescriptor descriptor) throws PropertyException {
        super(bean, descriptor);
        this.descriptor_ = descriptor;
    }

    @Override
    public Object getValue(int i) throws PropertyException {
        Object ret = null;
        try {
            Method m = this.descriptor_.getIndexedReadMethod();
            Integer index = new Integer(i);
            Object[] args = new Object[]{index};
            ret = m.invoke(this.getBean(), args);
        }
        catch (Exception e) {
            throw new PropertyException("Error getting property", e);
        }
        return ret;
    }

    @Override
    public boolean isIndexReadOnly() {
        return this.descriptor_.getIndexedWriteMethod() == null;
    }

    @Override
    public void setValue(int i, Object arg) throws ReadOnlyException, PropertyException {
        if (this.isIndexReadOnly()) {
            throw new ReadOnlyException("Property is readonly");
        }
        try {
            Object[] args = new Object[]{new Integer(i), arg};
            Method method = this.descriptor_.getIndexedWriteMethod();
            method.invoke(this.getBean(), args);
        }
        catch (Exception e) {
            throw new PropertyException("Error in setting value", e);
        }
    }

    @Override
    public Class getIndexedType() {
        return this.descriptor_.getIndexedPropertyType();
    }

    @Override
    public IndexedProperty getIndexedProperty() {
        return this;
    }
}

