/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.MemberFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MainMethodFilter
implements MemberFilter {
    @Override
    public boolean acceptsField(Field field) {
        return false;
    }

    @Override
    public boolean acceptsMethod(Method method) {
        if (!method.getName().endsWith("main")) {
            return false;
        }
        Class<?>[] pars = method.getParameterTypes();
        if (pars.length != 1) {
            return false;
        }
        if (!pars[0].getName().startsWith("[Ljava.lang.String")) {
            return false;
        }
        int mod = method.getModifiers();
        if (!Modifier.isPublic(mod)) {
            return false;
        }
        if (!Modifier.isStatic(mod)) {
            return false;
        }
        return method.getReturnType().getName().equals("void");
    }

    @Override
    public boolean acceptsConstructor(Constructor constructor) {
        return false;
    }
}

