/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.BeanInspector;
import com.atomikos.beans.Editor;
import com.atomikos.beans.Property;
import com.atomikos.beans.PropertyException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BeanWizard
implements PropertyChangeListener {
    private JPanel panel_ = new JPanel();
    private BeanInspector inspector_;

    private static Property[] filterProperties(Property[] props) throws PropertyException {
        if (props == null) {
            return null;
        }
        ArrayList<Property> list = new ArrayList<Property>();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].isHidden() || props[i].isReadOnly() || props[i].getEditor() == null) continue;
            list.add(props[i]);
        }
        return list.toArray(new Property[0]);
    }

    public BeanWizard(Object bean) throws PropertyException {
        this.panel_.setLayout(new BorderLayout());
        JPanel tempPanel = new JPanel();
        this.inspector_ = new BeanInspector(bean);
        Property[] properties = BeanWizard.filterProperties(this.inspector_.getProperties());
        int rows = 0;
        if (properties != null) {
            rows = properties.length;
        }
        tempPanel.setLayout(new GridLayout(rows, 1));
        for (int i = 0; i < rows; ++i) {
            Font font;
            JPanel propertyPanel = new JPanel();
            propertyPanel.setLayout(new GridLayout(1, 2));
            JLabel nameLabel = new JLabel(properties[i].getName());
            if (properties[i].isPreferred()) {
                font = new Font("SansSerif", 1, 12);
                nameLabel.setFont(font);
            } else {
                font = new Font("SansSerif", 0, 12);
                nameLabel.setFont(font);
            }
            propertyPanel.add(nameLabel);
            if (properties[i].getIndexedProperty() != null) {
                JButton button = new JButton("Edit");
                button.addActionListener(new ButtonListener(properties[i]));
                propertyPanel.add(button);
            } else {
                propertyPanel.add(properties[i].getEditor().getComponent());
            }
            properties[i].getEditor().addPropertyChangeListener(this);
            tempPanel.add(propertyPanel);
            this.panel_.setPreferredSize(new Dimension(300, 300));
            this.panel_.add((Component)new JScrollPane(tempPanel), "Center");
        }
    }

    public JPanel getPanel() {
        return this.panel_;
    }

    public Object getBean() {
        if (this.inspector_ == null) {
            return null;
        }
        return this.inspector_.getBean();
    }

    public void propertyChange(PropertyChangeEvent event) {
        Editor editor = (Editor)event.getSource();
        Property property = editor.getProperty();
        System.err.println("BeanWizard: propertyChange");
        try {
            System.err.println(editor.getEditedObject().getClass().getName());
            property.setValue(editor.getEditedObject());
            System.err.println("Property set: " + property.getName());
            System.err.println("to value: " + editor.getEditedObject());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class ButtonListener
    implements ActionListener {
        private Property property_;

        ButtonListener(Property property) {
            this.property_ = property;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JOptionPane.showMessageDialog(null, this.property_.getEditor().getComponent(), "Edit", -1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

