/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.BeanInspector;
import com.atomikos.beans.PrimitiveClasses;
import com.atomikos.beans.Property;
import com.atomikos.beans.PropertyException;
import com.atomikos.beans.ReadOnlyException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HtmlBeanWizard {
    private static final String PAR_NAME_PREFIX = "com.atomikos.beans.property.";
    private static final String BOOLEAN_PREFIX = "boolean.";
    private BeanInspector inspector;
    private Map parsedProperties = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;

    private static Property[] filterProperties(Property[] propertyArray) throws PropertyException {
        if (propertyArray == null) {
            return null;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (propertyArray[i].isHidden() || propertyArray[i].isReadOnly() || propertyArray[i].getEditor() == null || propertyArray[i].getIndexedProperty() != null) continue;
            arrayList.add(propertyArray[i]);
        }
        return arrayList.toArray(new Property[0]);
    }

    public void setClassName(String string) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(string);
        Object var3_3 = null;
        try {
            var3_3 = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        this.inspector = new BeanInspector(var3_3);
    }

    public String[] getPropertyNames() throws PropertyException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{};
        if (this.inspector == null) {
            return stringArray;
        }
        Property[] propertyArray = HtmlBeanWizard.filterProperties(this.inspector.getProperties());
        for (int i = 0; i < propertyArray.length; ++i) {
            arrayList.add(propertyArray[i].getName());
        }
        return arrayList.toArray(stringArray);
    }

    public Object getPropertyValue(String string) throws PropertyException {
        Object object = null;
        if (this.parsedProperties.containsKey(string)) {
            object = this.parsedProperties.get(string);
        } else if (this.inspector != null) {
            Property property = this.inspector.getProperty(string);
            try {
                object = property.getValue();
            }
            catch (PropertyException propertyException) {
                // empty catch block
            }
        }
        return object;
    }

    public void showPropertiesInForm(HttpServletResponse httpServletResponse) {
        if (this.inspector == null) {
            return;
        }
        try {
            PrintWriter printWriter = httpServletResponse.getWriter();
            Property[] propertyArray = HtmlBeanWizard.filterProperties(this.inspector.getProperties());
            printWriter.println("<table>");
            for (int i = 0; i < propertyArray.length; ++i) {
                Object object;
                printWriter.println("<tr>");
                String string = propertyArray[i].getName();
                printWriter.println("<td>" + string + "</td>");
                printWriter.println("<td>");
                Class clazz = PrimitiveClasses.getWrapperClass(propertyArray[i].getType());
                if (propertyArray[i].getAllowedValues() != null) {
                    printWriter.println("<select name=\"com.atomikos.beans.property." + string + "\" >");
                    object = propertyArray[i].getAllowedValues();
                    for (int j = 0; j < ((String[])object).length; ++j) {
                        printWriter.println("<option value=\"" + (String)object[j] + "\">" + (String)object[j]);
                    }
                    printWriter.println("</select>");
                } else if ((class$java$lang$Boolean == null ? HtmlBeanWizard.class$("java.lang.Boolean") : class$java$lang$Boolean).equals(clazz)) {
                    printWriter.println("<input type=\"checkbox\" value=\"true\" name=\"com.atomikos.beans.property.boolean." + string + "\"");
                    try {
                        object = (Boolean)propertyArray[i].getValue();
                        if (((Boolean)object).booleanValue()) {
                            printWriter.println(" checked ");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    printWriter.println(">");
                } else {
                    printWriter.print("<input type=\"text\" name=\"com.atomikos.beans.property." + string + "\" value=\"");
                    try {
                        object = propertyArray[i].getValue();
                        printWriter.print(object.toString());
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    printWriter.println("\" >");
                }
                printWriter.println("</td>");
                printWriter.println("</tr>");
            }
            printWriter.println("</table>");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void parseProperties(HttpServletRequest httpServletRequest) throws ServletException, ReadOnlyException {
        if (this.inspector == null) {
            return;
        }
        Enumeration enumeration = httpServletRequest.getParameterNames();
        this.parsedProperties = new HashMap();
        while (enumeration.hasMoreElements()) {
            boolean bl = false;
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(PAR_NAME_PREFIX)) continue;
            String string2 = string.substring(PAR_NAME_PREFIX.length());
            try {
                if (string2.startsWith(BOOLEAN_PREFIX)) {
                    bl = true;
                    string2 = string2.substring(BOOLEAN_PREFIX.length());
                }
                if (httpServletRequest.getParameter(string) != null && !httpServletRequest.getParameter(string).equals("")) {
                    if (!bl) {
                        this.setProperty(string2, httpServletRequest.getParameter(string));
                        this.parsedProperties.put(string2, httpServletRequest.getParameter(string));
                        continue;
                    }
                    this.setProperty(string2, "true");
                    this.parsedProperties.put(string2, new Boolean(true));
                    continue;
                }
                if (!bl) continue;
                this.setProperty(string2, "false");
                this.parsedProperties.put(string2, new Boolean(false));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setProperty(String string, String string2) throws ReadOnlyException, PropertyException {
        if (this.inspector == null) {
            throw new IllegalStateException("Not initialized");
        }
        Property property = this.inspector.getProperty(string);
        property.getEditor().setStringValue(string2);
        property.setValue(property.getEditor().getEditedObject());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

