/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.springmvc;

import com.atlassian.oai.validator.report.SimpleValidationReportFormat;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.report.ValidationReportFormat;
import com.atlassian.oai.validator.springmvc.InvalidRequestException;
import com.atlassian.oai.validator.springmvc.InvalidResponseException;
import com.atlassian.oai.validator.springmvc.ValidationReportHandler;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValidationReportHandler
implements ValidationReportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultValidationReportHandler.class);
    private static final String DELIMITER = ",";
    private final ValidationReportFormat validationReportFormat;

    public DefaultValidationReportHandler() {
        this((ValidationReportFormat)SimpleValidationReportFormat.getInstance());
    }

    public DefaultValidationReportHandler(@Nonnull ValidationReportFormat validationReportFormat) {
        Objects.requireNonNull(validationReportFormat, "validationReportFormat must not be null");
        this.validationReportFormat = validationReportFormat;
    }

    @Override
    public void handleRequestReport(String loggingKey, ValidationReport validationReport) {
        this.processApiValidationReport(ValidationReport.MessageContext.Location.REQUEST, loggingKey, validationReport);
    }

    @Override
    public void handleResponseReport(String loggingKey, ValidationReport validationReport) {
        this.processApiValidationReport(ValidationReport.MessageContext.Location.RESPONSE, loggingKey, validationReport);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processApiValidationReport(ValidationReport.MessageContext.Location location, String loggingKey, ValidationReport validationReport) {
        Set validationLevels = validationReport.sortedValidationLevels();
        if (validationLevels.contains(ValidationReport.Level.ERROR)) {
            RuntimeException validationException = this.createValidationException(validationReport, location);
            this.logApiValidation((arg_0, arg_1) -> ((Logger)LOG).error(arg_0, arg_1), location, loggingKey, validationLevels, this.validationReportFormat.apply(validationReport));
            throw validationException;
        }
        if (!(validationLevels.contains(ValidationReport.Level.INFO) || validationLevels.contains(ValidationReport.Level.WARN) || validationLevels.contains(ValidationReport.Level.IGNORE))) {
            LOG.debug("OpenAPI validation: {} - The {} is valid.", (Object)loggingKey, (Object)location.toString());
            return;
        }
        this.logApiValidation((arg_0, arg_1) -> ((Logger)LOG).info(arg_0, arg_1), location, loggingKey, validationLevels, this.validationReportFormat.apply(validationReport));
    }

    protected void logApiValidation(BiConsumer<String, String[]> logConsumer, ValidationReport.MessageContext.Location location, String loggingKey, Set<ValidationReport.Level> validationLevels, String message) {
        String logTemplate = "OpenAPI location={} key={} levels={} messages={}";
        String joinedLevels = validationLevels.stream().map(Objects::toString).collect(Collectors.joining(DELIMITER));
        logConsumer.accept("OpenAPI location={} key={} levels={} messages={}", new String[]{location.toString(), loggingKey, joinedLevels, message});
    }

    protected RuntimeException createValidationException(ValidationReport validationReport, ValidationReport.MessageContext.Location location) {
        if (location == ValidationReport.MessageContext.Location.REQUEST) {
            return new InvalidRequestException(validationReport);
        }
        return new InvalidResponseException(validationReport);
    }
}

