/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.pact;

import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.FileSource;
import au.com.dius.pact.core.model.IRequest;
import au.com.dius.pact.core.model.IResponse;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.RequestResponseInteraction;
import au.com.dius.pact.core.model.UrlSource;
import au.com.dius.pact.core.model.V4Pact;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerClientConfig;
import au.com.dius.pact.core.pactbroker.PactBrokerResult;
import au.com.dius.pact.provider.ConsumerInfo;
import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.pact.PactLevelResolverFactory;
import com.atlassian.oai.validator.pact.PactProviderValidationResults;
import com.atlassian.oai.validator.pact.PactRequest;
import com.atlassian.oai.validator.pact.PactResponse;
import com.atlassian.oai.validator.report.ValidationReport;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactProviderValidator {
    private static final Logger log = LoggerFactory.getLogger(PactProviderValidator.class);
    private final OpenApiInteractionValidator validator;
    private final Collection<ConsumerInfo> consumers = new ArrayList<ConsumerInfo>();

    private PactProviderValidator(@Nonnull OpenApiInteractionValidator validator, Collection<ConsumerInfo> consumers) {
        this.validator = Objects.requireNonNull(validator, "A validator is required");
        if (consumers != null) {
            this.consumers.addAll(consumers);
        }
    }

    public static Builder createFor(@Nonnull String specUrlOrPayload) {
        return new Builder().withApiSpecification(specUrlOrPayload);
    }

    public static Builder createFor(@Nonnull OpenApiInteractionValidator validator) {
        return new Builder().withValidator(validator);
    }

    public PactProviderValidationResults validate() {
        log.debug("Validating {} consumers against API spec", (Object)this.consumers.size());
        PactProviderValidationResults result = new PactProviderValidationResults();
        if (this.consumers.isEmpty()) {
            log.warn("No consumers supplied. No validation will be performed.");
            return result;
        }
        result.addConsumerResults(this.consumers.stream().filter(Objects::nonNull).map(this::doValidate).collect(Collectors.toList()));
        return result;
    }

    private PactProviderValidationResults.ConsumerResult doValidate(@Nonnull ConsumerInfo consumer) {
        Pact pact;
        log.debug("Validating consumer '{}' against API spec", (Object)consumer.getName());
        PactProviderValidationResults.ConsumerResult result = new PactProviderValidationResults.ConsumerResult(consumer.getName(), this.getPactSourceLocation(consumer));
        HashMap<String, List> options = new HashMap<String, List>();
        List authOptions = consumer.getPactFileAuthentication();
        if (authOptions != null && !authOptions.isEmpty()) {
            options.put("authentication", authOptions);
        }
        ((pact = DefaultPactReader.INSTANCE.loadPact(consumer.getPactSource(), options)) instanceof V4Pact ? (Pact)((V4Pact)pact).asRequestResponsePact().get() : pact).getInteractions().forEach(i -> {
            RequestResponseInteraction interaction = (RequestResponseInteraction)i;
            ValidationReport report = this.validator.validate(PactRequest.of((IRequest)interaction.getRequest()), PactResponse.of((IResponse)interaction.getResponse()));
            result.addInteractionResult(interaction.getDescription(), report);
        });
        return result;
    }

    private String getPactSourceLocation(@Nonnull ConsumerInfo consumer) {
        Object pactSource = consumer.getPactSource();
        if (pactSource instanceof BrokerUrlSource) {
            return ((BrokerUrlSource)pactSource).getUrl();
        }
        if (pactSource instanceof UrlSource) {
            return ((UrlSource)pactSource).getUrl();
        }
        if (pactSource instanceof FileSource) {
            return ((FileSource)pactSource).getFile().getAbsolutePath();
        }
        throw new IllegalStateException("Pact Source Not Valid.");
    }

    @VisibleForTesting
    Collection<ConsumerInfo> getConsumers() {
        return this.consumers;
    }

    public static class Builder {
        private String specUrlOrPayload;
        private OpenApiInteractionValidator validator;
        private final List<ConsumerInfo> consumers = new ArrayList<ConsumerInfo>();
        private String brokerUrl;
        private String providerName;
        private final Map<String, Object> brokerOptions = new HashMap<String, Object>();

        @Deprecated
        public Builder withSwaggerJsonUrl(String specUrlOrPayload) {
            this.specUrlOrPayload = specUrlOrPayload;
            return this;
        }

        public Builder withApiSpecification(String specUrlOrPayload) {
            this.specUrlOrPayload = specUrlOrPayload;
            return this;
        }

        public Builder withValidator(OpenApiInteractionValidator validator) {
            this.validator = validator;
            return this;
        }

        public Builder withConsumers(ConsumerInfo ... consumers) {
            this.consumers.addAll(Arrays.asList(consumers));
            return this;
        }

        public Builder withConsumer(String consumerName, String pactFileLocation) {
            ConsumerInfo consumerInfo = new ConsumerInfo(consumerName);
            consumerInfo.setPactSource((Object)new FileSource(new File(pactFileLocation)));
            this.consumers.add(consumerInfo);
            return this;
        }

        public Builder withConsumer(String consumerName, URL pactFileUrl) {
            ConsumerInfo consumerInfo = new ConsumerInfo(consumerName);
            consumerInfo.setPactSource((Object)new UrlSource(pactFileUrl.toString()));
            this.consumers.add(consumerInfo);
            return this;
        }

        public Builder withPactsFrom(String brokerUrl, String providerName) {
            this.brokerUrl = brokerUrl;
            this.providerName = providerName;
            return this;
        }

        public Builder withPactsFrom(String brokerUrl, String username, String password, String providerName) {
            this.withPactsFrom(brokerUrl, providerName);
            this.brokerOptions.clear();
            this.brokerOptions.put("authentication", Arrays.asList("basic", username, password));
            return this;
        }

        public PactProviderValidator build() {
            if (this.brokerUrl != null && this.providerName != null) {
                this.consumers.addAll(this.retrieveConsumers());
            }
            if (this.validator != null) {
                return new PactProviderValidator(this.validator, this.consumers);
            }
            OpenApiInteractionValidator validator = OpenApiInteractionValidator.createFor((String)this.specUrlOrPayload).withLevelResolver(PactLevelResolverFactory.create()).build();
            return new PactProviderValidator(validator, this.consumers);
        }

        @Nonnull
        private Collection<ConsumerInfo> retrieveConsumers() {
            log.debug("Retrieving consumers from broker '{}' for provider '{}'", (Object)this.brokerUrl, (Object)this.providerName);
            try {
                Collection consumersInfo = this.retrievePactBrokerConsumers().stream().map(arg_0 -> ((ConsumerInfo.Companion)ConsumerInfo.Companion).from(arg_0)).collect(Collectors.toList());
                if (consumersInfo.isEmpty()) {
                    log.info("No consumers found for provider '{}' on broker '{}'", (Object)this.providerName, (Object)this.brokerUrl);
                }
                return consumersInfo;
            }
            catch (Exception e) {
                log.error(String.format("Exception occurred while retrieving consumers for provider '%s' from broker '%s'", this.providerName, this.brokerUrl), (Throwable)e);
                return Collections.emptyList();
            }
        }

        private Collection<PactBrokerResult> retrievePactBrokerConsumers() {
            return new PactBrokerClient(this.brokerUrl, this.brokerOptions, new PactBrokerClientConfig()).fetchConsumers(this.providerName);
        }
    }
}

