/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow;

import com.atlassian.maven.plugins.jgitflow.AbstractJGitFlowMojo;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.JGitFlowReleaseException;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="hotfix-finish", aggregator=true)
public class HotfixFinishMojo
extends AbstractJGitFlowMojo {
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules = false;
    @Parameter(defaultValue="false", property="allowSnapshots")
    private boolean allowSnapshots = false;
    @Parameter(property="developmentVersion")
    private String developmentVersion;
    @Parameter(defaultValue="false", property="pushHotfixes")
    private boolean pushHotfixes = false;
    @Parameter(defaultValue="false", property="noDeploy")
    private boolean noDeploy = false;
    @Parameter(defaultValue="false", property="keepBranch")
    private boolean keepBranch = false;
    @Parameter(defaultValue="false", property="squash")
    private boolean squash = false;
    @Parameter(defaultValue="false", property="noTag")
    private boolean noTag = false;
    @Parameter(defaultValue="false", property="noHotfixBuild")
    private boolean noHotfixBuild = false;
    @Parameter(defaultValue="true", property="useReleaseProfile")
    private boolean useReleaseProfile = true;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies;
    @Parameter(property="tagMessage")
    private String tagMessage;
    @Component(hint="hotfix")
    FlowReleaseManager releaseManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReleaseContext ctx = new ReleaseContext(this.getBasedir());
        ctx.setInteractive(this.getSettings().isInteractiveMode()).setAutoVersionSubmodules(this.autoVersionSubmodules).setAllowSnapshots(this.allowSnapshots).setDefaultDevelopmentVersion(this.developmentVersion).setPushHotfixes(this.pushHotfixes).setKeepBranch(this.keepBranch).setSquash(this.squash).setNoTag(this.noTag).setNoDeploy(this.noDeploy).setUseReleaseProfile(this.useReleaseProfile).setTagMessage(this.tagMessage).setUpdateDependencies(this.updateDependencies).setEnableSshAgent(this.enableSshAgent).setAllowUntracked(this.allowUntracked).setAllowRemote(this.isRemoteAllowed()).setNoBuild(this.noHotfixBuild).setDefaultOriginUrl(this.defaultOriginUrl).setScmCommentPrefix(this.scmCommentPrefix).setFlowInitContext(this.getFlowInitContext().getJGitFlowContext());
        try {
            this.releaseManager.finish(ctx, this.getReactorProjects(), this.session);
        }
        catch (JGitFlowReleaseException e) {
            throw new MojoExecutionException("Error finishing hotfix: " + e.getMessage(), (Exception)e);
        }
    }
}

