/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow;

import com.atlassian.maven.plugins.jgitflow.AbstractJGitFlowMojo;
import com.atlassian.maven.plugins.jgitflow.exception.ProjectRewriteException;
import com.atlassian.maven.plugins.jgitflow.helper.ProjectHelper;
import com.atlassian.maven.plugins.jgitflow.rewrite.ArtifactReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ParentReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChangeset;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectRewriter;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="build-number", aggregator=true)
public class BuildNumberMojo
extends AbstractJGitFlowMojo {
    @Parameter(property="buildNumber")
    private String buildNumber;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies;
    @Component
    protected ProjectHelper projectHelper;
    @Component
    protected ProjectRewriter projectRewriter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<MavenProject> reactorProjects = this.getReactorProjects();
        String key = "buildNum";
        Map<String, String> originalVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map<String, String> featureVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map featureSuffixedVersions = Maps.transformValues(featureVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.endsWith("-SNAPSHOT")) {
                    return StringUtils.substringBeforeLast((String)input, (String)"-SNAPSHOT") + "-build" + BuildNumberMojo.this.buildNumber;
                }
                return input;
            }
        });
        for (MavenProject project : reactorProjects) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, featureSuffixedVersions)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(featureSuffixedVersions)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, featureSuffixedVersions, this.updateDependencies));
            try {
                this.projectRewriter.applyChanges(project, changes);
            }
            catch (ProjectRewriteException e) {
                throw new MojoExecutionException("Error updating poms with build numbers versions", (Exception)e);
            }
        }
    }
}

