/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.LessException;
import com.asual.lesscss.LessOptions;
import com.asual.lesscss.loader.ChainedResourceLoader;
import com.asual.lesscss.loader.ClasspathResourceLoader;
import com.asual.lesscss.loader.CssProcessingResourceLoader;
import com.asual.lesscss.loader.FilesystemResourceLoader;
import com.asual.lesscss.loader.HTTPResourceLoader;
import com.asual.lesscss.loader.ResourceLoader;
import com.asual.lesscss.loader.UnixNewlinesResourceLoader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

public class LessEngine {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final LessOptions options;
    private final ResourceLoader loader;
    private Scriptable scope;
    private Function compile;

    public LessEngine() {
        this(new LessOptions());
    }

    public LessEngine(LessOptions options) {
        this(options, LessEngine.defaultResourceLoader(options));
    }

    private static ResourceLoader defaultResourceLoader(LessOptions options) {
        ResourceLoader resourceLoader = new ChainedResourceLoader(new FilesystemResourceLoader(), new ClasspathResourceLoader(LessEngine.class.getClassLoader()), new HTTPResourceLoader());
        if (options.isCss()) {
            return new CssProcessingResourceLoader(resourceLoader);
        }
        resourceLoader = new UnixNewlinesResourceLoader(resourceLoader);
        return resourceLoader;
    }

    public LessEngine(LessOptions options, ResourceLoader loader) {
        this.options = options;
        this.loader = loader;
        try {
            this.logger.debug((Object)"Initializing LESS Engine.");
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL less = options.getLess();
            URL env = classLoader.getResource("META-INF/env.js");
            URL engine = classLoader.getResource("META-INF/engine.js");
            URL cssmin = classLoader.getResource("META-INF/cssmin.js");
            Context cx = Context.enter();
            this.logger.debug((Object)("Using implementation version: " + cx.getImplementationVersion()));
            cx.setOptimizationLevel(9);
            Global global = new Global();
            global.init(cx);
            this.scope = cx.initStandardObjects((ScriptableObject)global);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(env.openConnection().getInputStream()), env.getFile(), 1, null);
            Scriptable lessEnv = (Scriptable)this.scope.get("lessenv", this.scope);
            lessEnv.put("charset", lessEnv, (Object)options.getCharset());
            lessEnv.put("css", lessEnv, (Object)options.isCss());
            lessEnv.put("loader", lessEnv, Context.javaToJS((Object)loader, (Scriptable)this.scope));
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(less.openConnection().getInputStream()), less.getFile(), 1, null);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(cssmin.openConnection().getInputStream()), cssmin.getFile(), 1, null);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(engine.openConnection().getInputStream()), engine.getFile(), 1, null);
            this.compile = (Function)this.scope.get("compile", this.scope);
            Context.exit();
        }
        catch (Exception e) {
            this.logger.error((Object)"LESS Engine intialization failed.", (Throwable)e);
        }
    }

    public String compile(String input) throws LessException {
        return this.compile(input, null, false);
    }

    public String compile(String input, String location) throws LessException {
        return this.compile(input, location, false);
    }

    public String compile(String input, String location, boolean compress) throws LessException {
        try {
            long time = System.currentTimeMillis();
            String result = this.call(this.compile, new Object[]{input, location == null ? "" : location, compress});
            this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    public String compile(URL input) throws LessException {
        return this.compile(input, false);
    }

    public String compile(URL input, boolean compress) throws LessException {
        try {
            long time = System.currentTimeMillis();
            String location = input.toString();
            this.logger.debug((Object)("Compiling URL: " + location));
            String source = this.loader.load(location, this.options.getCharset());
            String result = this.call(this.compile, new Object[]{source, location, compress});
            this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    public String compile(File input) throws LessException {
        return this.compile(input, false);
    }

    public String compile(File input, boolean compress) throws LessException {
        try {
            long time = System.currentTimeMillis();
            String location = input.getAbsolutePath();
            this.logger.debug((Object)("Compiling File: file:" + location));
            String source = this.loader.load(location, this.options.getCharset());
            String result = this.call(this.compile, new Object[]{source, location, compress});
            this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    public void compile(File input, File output) throws LessException, IOException {
        this.compile(input, output, false);
    }

    public void compile(File input, File output, boolean compress) throws LessException, IOException {
        try {
            String content = this.compile(input, compress);
            if (!output.exists()) {
                output.createNewFile();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(output));
            bw.write(content);
            bw.close();
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    private synchronized String call(Function fn, Object[] args) {
        return (String)Context.call(null, (Callable)fn, (Scriptable)this.scope, (Scriptable)this.scope, (Object[])args);
    }

    private LessException parseLessException(Exception root) throws LessException {
        this.logger.debug((Object)"Parsing LESS Exception", (Throwable)root);
        if (root instanceof JavaScriptException) {
            Scriptable value = (Scriptable)((JavaScriptException)root).getValue();
            String type = ScriptableObject.getProperty((Scriptable)value, (String)"type").toString() + " Error";
            String message = ScriptableObject.getProperty((Scriptable)value, (String)"message").toString();
            String filename = "";
            if (ScriptableObject.getProperty((Scriptable)value, (String)"filename") != null) {
                filename = ScriptableObject.getProperty((Scriptable)value, (String)"filename").toString();
            }
            int line = -1;
            if (ScriptableObject.getProperty((Scriptable)value, (String)"line") != null) {
                line = ((Double)ScriptableObject.getProperty((Scriptable)value, (String)"line")).intValue();
            }
            int column = -1;
            if (ScriptableObject.getProperty((Scriptable)value, (String)"column") != null) {
                column = ((Double)ScriptableObject.getProperty((Scriptable)value, (String)"column")).intValue();
            }
            ArrayList<String> extractList = new ArrayList<String>();
            if (ScriptableObject.getProperty((Scriptable)value, (String)"extract") != null) {
                NativeArray extract = (NativeArray)ScriptableObject.getProperty((Scriptable)value, (String)"extract");
                int i = 0;
                while ((long)i < extract.getLength()) {
                    if (extract.get(i, (Scriptable)extract) instanceof String) {
                        extractList.add(((String)extract.get(i, (Scriptable)extract)).replace("\t", " "));
                    }
                    ++i;
                }
            }
            throw new LessException(message, type, filename, line, column, extractList);
        }
        throw new LessException(root);
    }
}

