/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class TranscriptReadyStatus {
    public static final TranscriptReadyStatus COMPLETED = new TranscriptReadyStatus(Value.COMPLETED, "completed");
    public static final TranscriptReadyStatus ERROR = new TranscriptReadyStatus(Value.ERROR, "error");
    private final Value value;
    private final String string;

    TranscriptReadyStatus(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TranscriptReadyStatus && this.string.equals(((TranscriptReadyStatus)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case COMPLETED: {
                return visitor.visitCompleted();
            }
            case ERROR: {
                return visitor.visitError();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static TranscriptReadyStatus valueOf(String value) {
        switch (value) {
            case "completed": {
                return COMPLETED;
            }
            case "error": {
                return ERROR;
            }
        }
        return new TranscriptReadyStatus(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitCompleted();

        public T visitError();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        COMPLETED,
        ERROR,
        UNKNOWN;

    }
}

