/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.realtime.types.FinalTranscript;
import com.assemblyai.api.resources.realtime.types.PartialTranscript;
import com.assemblyai.api.resources.realtime.types.RealtimeError;
import com.assemblyai.api.resources.realtime.types.SessionBegins;
import com.assemblyai.api.resources.realtime.types.SessionInformation;
import com.assemblyai.api.resources.realtime.types.SessionTerminated;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class ReceiveMessage {
    private final Object value;
    private final int type;

    private ReceiveMessage(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((SessionBegins)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((PartialTranscript)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((FinalTranscript)this.value);
        }
        if (this.type == 3) {
            return visitor.visit((SessionInformation)this.value);
        }
        if (this.type == 4) {
            return visitor.visit((SessionTerminated)this.value);
        }
        if (this.type == 5) {
            return visitor.visit((RealtimeError)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ReceiveMessage && this.equalTo((ReceiveMessage)other);
    }

    private boolean equalTo(ReceiveMessage other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static ReceiveMessage of(SessionBegins value) {
        return new ReceiveMessage(value, 0);
    }

    public static ReceiveMessage of(PartialTranscript value) {
        return new ReceiveMessage(value, 1);
    }

    public static ReceiveMessage of(FinalTranscript value) {
        return new ReceiveMessage(value, 2);
    }

    public static ReceiveMessage of(SessionInformation value) {
        return new ReceiveMessage(value, 3);
    }

    public static ReceiveMessage of(SessionTerminated value) {
        return new ReceiveMessage(value, 4);
    }

    public static ReceiveMessage of(RealtimeError value) {
        return new ReceiveMessage(value, 5);
    }

    static final class Deserializer
    extends StdDeserializer<ReceiveMessage> {
        Deserializer() {
            super(ReceiveMessage.class);
        }

        public ReceiveMessage deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return ReceiveMessage.of((SessionBegins)ObjectMappers.JSON_MAPPER.convertValue(value, SessionBegins.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return ReceiveMessage.of((PartialTranscript)ObjectMappers.JSON_MAPPER.convertValue(value, PartialTranscript.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        return ReceiveMessage.of((FinalTranscript)ObjectMappers.JSON_MAPPER.convertValue(value, FinalTranscript.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        try {
                            return ReceiveMessage.of((SessionInformation)ObjectMappers.JSON_MAPPER.convertValue(value, SessionInformation.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException4) {
                            try {
                                return ReceiveMessage.of((SessionTerminated)ObjectMappers.JSON_MAPPER.convertValue(value, SessionTerminated.class));
                            }
                            catch (IllegalArgumentException illegalArgumentException5) {
                                try {
                                    return ReceiveMessage.of((RealtimeError)ObjectMappers.JSON_MAPPER.convertValue(value, RealtimeError.class));
                                }
                                catch (IllegalArgumentException illegalArgumentException6) {
                                    throw new JsonParseException(p, "Failed to deserialize");
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(SessionBegins var1);

        public T visit(PartialTranscript var1);

        public T visit(FinalTranscript var1);

        public T visit(SessionInformation var1);

        public T visit(SessionTerminated var1);

        public T visit(RealtimeError var1);
    }
}

