/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LemurUsage {
    private final int inputTokens;
    private final int outputTokens;
    private final Map<String, Object> additionalProperties;

    private LemurUsage(int inputTokens, int outputTokens, Map<String, Object> additionalProperties) {
        this.inputTokens = inputTokens;
        this.outputTokens = outputTokens;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="input_tokens")
    public int getInputTokens() {
        return this.inputTokens;
    }

    @JsonProperty(value="output_tokens")
    public int getOutputTokens() {
        return this.outputTokens;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LemurUsage && this.equalTo((LemurUsage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LemurUsage other) {
        return this.inputTokens == other.inputTokens && this.outputTokens == other.outputTokens;
    }

    public int hashCode() {
        return Objects.hash(this.inputTokens, this.outputTokens);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InputTokensStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements InputTokensStage,
    OutputTokensStage,
    _FinalStage {
        private int inputTokens;
        private int outputTokens;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LemurUsage other) {
            this.inputTokens(other.getInputTokens());
            this.outputTokens(other.getOutputTokens());
            return this;
        }

        @Override
        @JsonSetter(value="input_tokens")
        public OutputTokensStage inputTokens(int inputTokens) {
            this.inputTokens = inputTokens;
            return this;
        }

        @Override
        @JsonSetter(value="output_tokens")
        public _FinalStage outputTokens(int outputTokens) {
            this.outputTokens = outputTokens;
            return this;
        }

        @Override
        public LemurUsage build() {
            return new LemurUsage(this.inputTokens, this.outputTokens, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LemurUsage build();
    }

    public static interface OutputTokensStage {
        public _FinalStage outputTokens(int var1);
    }

    public static interface InputTokensStage {
        public OutputTokensStage inputTokens(int var1);

        public Builder from(LemurUsage var1);
    }
}

