/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.core;

import com.assemblyai.api.core.UserAgent;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class UserAgentInterceptor
implements Interceptor {
    private final UserAgent userAgent;

    public UserAgentInterceptor(UserAgent userAgent) {
        this.userAgent = userAgent;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        String assemblyAIUserAgentString;
        if (this.userAgent == null) {
            return chain.proceed(chain.request());
        }
        Request originalRequest = chain.request();
        String userAgentString = originalRequest.headers().get("User-Agent");
        if (userAgentString != null) {
            if (userAgentString.contains("AssemblyAI/")) {
                return chain.proceed(chain.request());
            }
        } else {
            userAgentString = "";
        }
        if ((assemblyAIUserAgentString = this.userAgent.toAssemblyAIUserAgentString()) == null || assemblyAIUserAgentString.isEmpty()) {
            return chain.proceed(chain.request());
        }
        userAgentString = userAgentString + " " + assemblyAIUserAgentString;
        Request requestWithUserAgent = originalRequest.newBuilder().header("User-Agent", userAgentString).build();
        return chain.proceed(requestWithUserAgent);
    }
}

