/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class TranscriptReadyStatus {
    public static final TranscriptReadyStatus COMPLETED = new TranscriptReadyStatus(Value.COMPLETED, "completed");

    public static final TranscriptReadyStatus ERROR = new TranscriptReadyStatus(Value.ERROR, "error");

    private final Value value;

    private final String string;

    TranscriptReadyStatus(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return value;
    }

    @java.lang.Override
    @JsonValue
    public String toString() {
        return this.string;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        return (this == other)
                || (other instanceof TranscriptReadyStatus
                        && this.string.equals(((TranscriptReadyStatus) other).string));
    }

    @java.lang.Override
    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (value) {
            case COMPLETED:
                return visitor.visitCompleted();
            case ERROR:
                return visitor.visitError();
            case UNKNOWN:
            default:
                return visitor.visitUnknown(string);
        }
    }

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    public static TranscriptReadyStatus valueOf(String value) {
        switch (value) {
            case "completed":
                return COMPLETED;
            case "error":
                return ERROR;
            default:
                return new TranscriptReadyStatus(Value.UNKNOWN, value);
        }
    }

    public enum Value {
        COMPLETED,

        ERROR,

        UNKNOWN
    }

    public interface Visitor<T> {
        T visitCompleted();

        T visitError();

        T visitUnknown(String unknownType);
    }
}
