/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class TranscriptBoostParam {
    public static final TranscriptBoostParam LOW = new TranscriptBoostParam(Value.LOW, "low");

    public static final TranscriptBoostParam DEFAULT = new TranscriptBoostParam(Value.DEFAULT, "default");

    public static final TranscriptBoostParam HIGH = new TranscriptBoostParam(Value.HIGH, "high");

    private final Value value;

    private final String string;

    TranscriptBoostParam(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return value;
    }

    @java.lang.Override
    @JsonValue
    public String toString() {
        return this.string;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        return (this == other)
                || (other instanceof TranscriptBoostParam && this.string.equals(((TranscriptBoostParam) other).string));
    }

    @java.lang.Override
    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (value) {
            case LOW:
                return visitor.visitLow();
            case DEFAULT:
                return visitor.visitDefault();
            case HIGH:
                return visitor.visitHigh();
            case UNKNOWN:
            default:
                return visitor.visitUnknown(string);
        }
    }

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    public static TranscriptBoostParam valueOf(String value) {
        switch (value) {
            case "low":
                return LOW;
            case "default":
                return DEFAULT;
            case "high":
                return HIGH;
            default:
                return new TranscriptBoostParam(Value.UNKNOWN, value);
        }
    }

    public enum Value {
        LOW,

        DEFAULT,

        HIGH,

        UNKNOWN
    }

    public interface Visitor<T> {
        T visitLow();

        T visitDefault();

        T visitHigh();

        T visitUnknown(String unknownType);
    }
}
