/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = SeverityScoreSummary.Builder.class)
public final class SeverityScoreSummary {
    private final double low;

    private final double medium;

    private final double high;

    private final Map<String, Object> additionalProperties;

    private SeverityScoreSummary(double low, double medium, double high, Map<String, Object> additionalProperties) {
        this.low = low;
        this.medium = medium;
        this.high = high;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("low")
    public double getLow() {
        return low;
    }

    @JsonProperty("medium")
    public double getMedium() {
        return medium;
    }

    @JsonProperty("high")
    public double getHigh() {
        return high;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SeverityScoreSummary && equalTo((SeverityScoreSummary) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SeverityScoreSummary other) {
        return low == other.low && medium == other.medium && high == other.high;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.low, this.medium, this.high);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LowStage builder() {
        return new Builder();
    }

    public interface LowStage {
        MediumStage low(double low);

        Builder from(SeverityScoreSummary other);
    }

    public interface MediumStage {
        HighStage medium(double medium);
    }

    public interface HighStage {
        _FinalStage high(double high);
    }

    public interface _FinalStage {
        SeverityScoreSummary build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements LowStage, MediumStage, HighStage, _FinalStage {
        private double low;

        private double medium;

        private double high;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SeverityScoreSummary other) {
            low(other.getLow());
            medium(other.getMedium());
            high(other.getHigh());
            return this;
        }

        @java.lang.Override
        @JsonSetter("low")
        public MediumStage low(double low) {
            this.low = low;
            return this;
        }

        @java.lang.Override
        @JsonSetter("medium")
        public HighStage medium(double medium) {
            this.medium = medium;
            return this;
        }

        @java.lang.Override
        @JsonSetter("high")
        public _FinalStage high(double high) {
            this.high = high;
            return this;
        }

        @java.lang.Override
        public SeverityScoreSummary build() {
            return new SeverityScoreSummary(low, medium, high, additionalProperties);
        }
    }
}
