/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = ContentSafetyLabelsResult.Builder.class)
public final class ContentSafetyLabelsResult {
    private final AudioIntelligenceModelStatus status;

    private final List<ContentSafetyLabelResult> results;

    private final Map<String, Double> summary;

    private final Map<String, SeverityScoreSummary> severityScoreSummary;

    private final Map<String, Object> additionalProperties;

    private ContentSafetyLabelsResult(
            AudioIntelligenceModelStatus status,
            List<ContentSafetyLabelResult> results,
            Map<String, Double> summary,
            Map<String, SeverityScoreSummary> severityScoreSummary,
            Map<String, Object> additionalProperties) {
        this.status = status;
        this.results = results;
        this.summary = summary;
        this.severityScoreSummary = severityScoreSummary;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The status of the Content Moderation model. Either success, or unavailable in the rare case that the model failed.
     */
    @JsonProperty("status")
    public AudioIntelligenceModelStatus getStatus() {
        return status;
    }

    @JsonProperty("results")
    public List<ContentSafetyLabelResult> getResults() {
        return results;
    }

    /**
     * @return A summary of the Content Moderation confidence results for the entire audio file
     */
    @JsonProperty("summary")
    public Map<String, Double> getSummary() {
        return summary;
    }

    /**
     * @return A summary of the Content Moderation severity results for the entire audio file
     */
    @JsonProperty("severity_score_summary")
    public Map<String, SeverityScoreSummary> getSeverityScoreSummary() {
        return severityScoreSummary;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContentSafetyLabelsResult && equalTo((ContentSafetyLabelsResult) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSafetyLabelsResult other) {
        return status.equals(other.status)
                && results.equals(other.results)
                && summary.equals(other.summary)
                && severityScoreSummary.equals(other.severityScoreSummary);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.status, this.results, this.summary, this.severityScoreSummary);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StatusStage builder() {
        return new Builder();
    }

    public interface StatusStage {
        _FinalStage status(AudioIntelligenceModelStatus status);

        Builder from(ContentSafetyLabelsResult other);
    }

    public interface _FinalStage {
        ContentSafetyLabelsResult build();

        _FinalStage results(List<ContentSafetyLabelResult> results);

        _FinalStage addResults(ContentSafetyLabelResult results);

        _FinalStage addAllResults(List<ContentSafetyLabelResult> results);

        _FinalStage summary(Map<String, Double> summary);

        _FinalStage putAllSummary(Map<String, Double> summary);

        _FinalStage summary(String key, Double value);

        _FinalStage severityScoreSummary(Map<String, SeverityScoreSummary> severityScoreSummary);

        _FinalStage putAllSeverityScoreSummary(Map<String, SeverityScoreSummary> severityScoreSummary);

        _FinalStage severityScoreSummary(String key, SeverityScoreSummary value);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements StatusStage, _FinalStage {
        private AudioIntelligenceModelStatus status;

        private Map<String, SeverityScoreSummary> severityScoreSummary = new LinkedHashMap<>();

        private Map<String, Double> summary = new LinkedHashMap<>();

        private List<ContentSafetyLabelResult> results = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ContentSafetyLabelsResult other) {
            status(other.getStatus());
            results(other.getResults());
            summary(other.getSummary());
            severityScoreSummary(other.getSeverityScoreSummary());
            return this;
        }

        /**
         * <p>The status of the Content Moderation model. Either success, or unavailable in the rare case that the model failed.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("status")
        public _FinalStage status(AudioIntelligenceModelStatus status) {
            this.status = status;
            return this;
        }

        /**
         * <p>A summary of the Content Moderation severity results for the entire audio file</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage severityScoreSummary(String key, SeverityScoreSummary value) {
            this.severityScoreSummary.put(key, value);
            return this;
        }

        /**
         * <p>A summary of the Content Moderation severity results for the entire audio file</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage putAllSeverityScoreSummary(Map<String, SeverityScoreSummary> severityScoreSummary) {
            this.severityScoreSummary.putAll(severityScoreSummary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "severity_score_summary", nulls = Nulls.SKIP)
        public _FinalStage severityScoreSummary(Map<String, SeverityScoreSummary> severityScoreSummary) {
            this.severityScoreSummary.clear();
            this.severityScoreSummary.putAll(severityScoreSummary);
            return this;
        }

        /**
         * <p>A summary of the Content Moderation confidence results for the entire audio file</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage summary(String key, Double value) {
            this.summary.put(key, value);
            return this;
        }

        /**
         * <p>A summary of the Content Moderation confidence results for the entire audio file</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage putAllSummary(Map<String, Double> summary) {
            this.summary.putAll(summary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "summary", nulls = Nulls.SKIP)
        public _FinalStage summary(Map<String, Double> summary) {
            this.summary.clear();
            this.summary.putAll(summary);
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllResults(List<ContentSafetyLabelResult> results) {
            this.results.addAll(results);
            return this;
        }

        @java.lang.Override
        public _FinalStage addResults(ContentSafetyLabelResult results) {
            this.results.add(results);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "results", nulls = Nulls.SKIP)
        public _FinalStage results(List<ContentSafetyLabelResult> results) {
            this.results.clear();
            this.results.addAll(results);
            return this;
        }

        @java.lang.Override
        public ContentSafetyLabelsResult build() {
            return new ContentSafetyLabelsResult(status, results, summary, severityScoreSummary, additionalProperties);
        }
    }
}
