/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = SessionInformation.Builder.class)
public final class SessionInformation {
    private final double audioDurationSeconds;

    private final Map<String, Object> additionalProperties;

    private SessionInformation(double audioDurationSeconds, Map<String, Object> additionalProperties) {
        this.audioDurationSeconds = audioDurationSeconds;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Describes the type of the message
     */
    @JsonProperty("message_type")
    public String getMessageType() {
        return "SessionInformation";
    }

    /**
     * @return The total duration of the audio in seconds
     */
    @JsonProperty("audio_duration_seconds")
    public double getAudioDurationSeconds() {
        return audioDurationSeconds;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SessionInformation && equalTo((SessionInformation) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SessionInformation other) {
        return audioDurationSeconds == other.audioDurationSeconds;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.audioDurationSeconds);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AudioDurationSecondsStage builder() {
        return new Builder();
    }

    public interface AudioDurationSecondsStage {
        _FinalStage audioDurationSeconds(double audioDurationSeconds);

        Builder from(SessionInformation other);
    }

    public interface _FinalStage {
        SessionInformation build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements AudioDurationSecondsStage, _FinalStage {
        private double audioDurationSeconds;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SessionInformation other) {
            audioDurationSeconds(other.getAudioDurationSeconds());
            return this;
        }

        /**
         * <p>The total duration of the audio in seconds</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("audio_duration_seconds")
        public _FinalStage audioDurationSeconds(double audioDurationSeconds) {
            this.audioDurationSeconds = audioDurationSeconds;
            return this;
        }

        @java.lang.Override
        public SessionInformation build() {
            return new SessionInformation(audioDurationSeconds, additionalProperties);
        }
    }
}
