/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using = ReceiveMessage.Deserializer.class)
public final class ReceiveMessage {
    private final Object value;

    private final int type;

    private ReceiveMessage(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((SessionBegins) this.value);
        } else if (this.type == 1) {
            return visitor.visit((PartialTranscript) this.value);
        } else if (this.type == 2) {
            return visitor.visit((FinalTranscript) this.value);
        } else if (this.type == 3) {
            return visitor.visit((SessionInformation) this.value);
        } else if (this.type == 4) {
            return visitor.visit((SessionTerminated) this.value);
        } else if (this.type == 5) {
            return visitor.visit((RealtimeError) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ReceiveMessage && equalTo((ReceiveMessage) other);
    }

    private boolean equalTo(ReceiveMessage other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static ReceiveMessage of(SessionBegins value) {
        return new ReceiveMessage(value, 0);
    }

    public static ReceiveMessage of(PartialTranscript value) {
        return new ReceiveMessage(value, 1);
    }

    public static ReceiveMessage of(FinalTranscript value) {
        return new ReceiveMessage(value, 2);
    }

    public static ReceiveMessage of(SessionInformation value) {
        return new ReceiveMessage(value, 3);
    }

    public static ReceiveMessage of(SessionTerminated value) {
        return new ReceiveMessage(value, 4);
    }

    public static ReceiveMessage of(RealtimeError value) {
        return new ReceiveMessage(value, 5);
    }

    public interface Visitor<T> {
        T visit(SessionBegins value);

        T visit(PartialTranscript value);

        T visit(FinalTranscript value);

        T visit(SessionInformation value);

        T visit(SessionTerminated value);

        T visit(RealtimeError value);
    }

    static final class Deserializer extends StdDeserializer<ReceiveMessage> {
        Deserializer() {
            super(ReceiveMessage.class);
        }

        @java.lang.Override
        public ReceiveMessage deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, SessionBegins.class));
            } catch (IllegalArgumentException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, PartialTranscript.class));
            } catch (IllegalArgumentException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, FinalTranscript.class));
            } catch (IllegalArgumentException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, SessionInformation.class));
            } catch (IllegalArgumentException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, SessionTerminated.class));
            } catch (IllegalArgumentException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, RealtimeError.class));
            } catch (IllegalArgumentException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }
}
