/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using = RealtimeMessage.Deserializer.class)
public final class RealtimeMessage {
    private final Object value;

    private final int type;

    private RealtimeMessage(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((SessionBegins) this.value);
        } else if (this.type == 1) {
            return visitor.visit((PartialTranscript) this.value);
        } else if (this.type == 2) {
            return visitor.visit((FinalTranscript) this.value);
        } else if (this.type == 3) {
            return visitor.visit((SessionTerminated) this.value);
        } else if (this.type == 4) {
            return visitor.visit((RealtimeError) this.value);
        } else if (this.type == 5) {
            return visitor.visit((SessionInformation) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RealtimeMessage && equalTo((RealtimeMessage) other);
    }

    private boolean equalTo(RealtimeMessage other) {
        return value.equals(other.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    public static RealtimeMessage of(SessionBegins value) {
        return new RealtimeMessage(value, 0);
    }

    public static RealtimeMessage of(PartialTranscript value) {
        return new RealtimeMessage(value, 1);
    }

    public static RealtimeMessage of(FinalTranscript value) {
        return new RealtimeMessage(value, 2);
    }

    public static RealtimeMessage of(SessionTerminated value) {
        return new RealtimeMessage(value, 3);
    }

    public static RealtimeMessage of(RealtimeError value) {
        return new RealtimeMessage(value, 4);
    }

    public static RealtimeMessage of(SessionInformation value) {
        return new RealtimeMessage(value, 5);
    }

    public interface Visitor<T> {
        T visit(SessionBegins value);

        T visit(PartialTranscript value);

        T visit(FinalTranscript value);

        T visit(SessionTerminated value);

        T visit(RealtimeError value);

        T visit(SessionInformation value);
    }

    static final class Deserializer extends StdDeserializer<RealtimeMessage> {
        Deserializer() {
            super(RealtimeMessage.class);
        }

        @Override
        public RealtimeMessage deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String json = ObjectMappers.JSON_MAPPER.writeValueAsString(p.readValueAs(Object.class));

            Optional<SessionBegins> sessionBegins = ObjectMappers.parse(json, SessionBegins.class);
            if (sessionBegins.isPresent()) {
                return of(sessionBegins.get());
            }

            Optional<PartialTranscript> partialTranscript = ObjectMappers.parse(json, PartialTranscript.class);
            if (partialTranscript.isPresent()) {
                return of(partialTranscript.get());
            }

            Optional<FinalTranscript> finalTranscript = ObjectMappers.parse(json, FinalTranscript.class);
            if (finalTranscript.isPresent()) {
                return of(finalTranscript.get());
            }

            Optional<SessionTerminated> sessionTerminated = ObjectMappers.parse(json, SessionTerminated.class);
            if (sessionTerminated.isPresent()) {
                return of(sessionTerminated.get());
            }

            Optional<RealtimeError> realtimeError = ObjectMappers.parse(json, RealtimeError.class);
            if (realtimeError.isPresent()) {
                return of(sessionBegins.get());
            }

            throw new JsonParseException(p, "Received unknown RealtimeMessage: " + json);
        }
    }
}
