/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.lemur.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = PurgeLemurRequestDataResponse.Builder.class)
public final class PurgeLemurRequestDataResponse {
    private final String requestId;

    private final String requestIdToPurge;

    private final boolean deleted;

    private final Map<String, Object> additionalProperties;

    private PurgeLemurRequestDataResponse(
            String requestId, String requestIdToPurge, boolean deleted, Map<String, Object> additionalProperties) {
        this.requestId = requestId;
        this.requestIdToPurge = requestIdToPurge;
        this.deleted = deleted;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The ID of the deletion request of the LeMUR request
     */
    @JsonProperty("request_id")
    public String getRequestId() {
        return requestId;
    }

    /**
     * @return The ID of the LeMUR request to purge the data for
     */
    @JsonProperty("request_id_to_purge")
    public String getRequestIdToPurge() {
        return requestIdToPurge;
    }

    /**
     * @return Whether the request data was deleted
     */
    @JsonProperty("deleted")
    public boolean getDeleted() {
        return deleted;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PurgeLemurRequestDataResponse && equalTo((PurgeLemurRequestDataResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PurgeLemurRequestDataResponse other) {
        return requestId.equals(other.requestId)
                && requestIdToPurge.equals(other.requestIdToPurge)
                && deleted == other.deleted;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.requestId, this.requestIdToPurge, this.deleted);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RequestIdStage builder() {
        return new Builder();
    }

    public interface RequestIdStage {
        RequestIdToPurgeStage requestId(String requestId);

        Builder from(PurgeLemurRequestDataResponse other);
    }

    public interface RequestIdToPurgeStage {
        DeletedStage requestIdToPurge(String requestIdToPurge);
    }

    public interface DeletedStage {
        _FinalStage deleted(boolean deleted);
    }

    public interface _FinalStage {
        PurgeLemurRequestDataResponse build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements RequestIdStage, RequestIdToPurgeStage, DeletedStage, _FinalStage {
        private String requestId;

        private String requestIdToPurge;

        private boolean deleted;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PurgeLemurRequestDataResponse other) {
            requestId(other.getRequestId());
            requestIdToPurge(other.getRequestIdToPurge());
            deleted(other.getDeleted());
            return this;
        }

        /**
         * <p>The ID of the deletion request of the LeMUR request</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("request_id")
        public RequestIdToPurgeStage requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        /**
         * <p>The ID of the LeMUR request to purge the data for</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("request_id_to_purge")
        public DeletedStage requestIdToPurge(String requestIdToPurge) {
            this.requestIdToPurge = requestIdToPurge;
            return this;
        }

        /**
         * <p>Whether the request data was deleted</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("deleted")
        public _FinalStage deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @java.lang.Override
        public PurgeLemurRequestDataResponse build() {
            return new PurgeLemurRequestDataResponse(requestId, requestIdToPurge, deleted, additionalProperties);
        }
    }
}
