/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.lemur.requests;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.lemur.types.ILemurBaseParams;
import com.assemblyai.api.resources.lemur.types.LemurBaseParamsContext;
import com.assemblyai.api.resources.lemur.types.LemurModel;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = LemurTaskParams.Builder.class)
public final class LemurTaskParams implements ILemurBaseParams {
    private final Optional<List<String>> transcriptIds;

    private final Optional<String> inputText;

    private final Optional<LemurBaseParamsContext> context;

    private final Optional<LemurModel> finalModel;

    private final Optional<Integer> maxOutputSize;

    private final Optional<Double> temperature;

    private final String prompt;

    private final Map<String, Object> additionalProperties;

    private LemurTaskParams(
            Optional<List<String>> transcriptIds,
            Optional<String> inputText,
            Optional<LemurBaseParamsContext> context,
            Optional<LemurModel> finalModel,
            Optional<Integer> maxOutputSize,
            Optional<Double> temperature,
            String prompt,
            Map<String, Object> additionalProperties) {
        this.transcriptIds = transcriptIds;
        this.inputText = inputText;
        this.context = context;
        this.finalModel = finalModel;
        this.maxOutputSize = maxOutputSize;
        this.temperature = temperature;
        this.prompt = prompt;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return A list of completed transcripts with text. Up to a maximum of 100 files or 100 hours, whichever is lower.
     * Use either transcript_ids or input_text as input into LeMUR.
     */
    @JsonProperty("transcript_ids")
    @java.lang.Override
    public Optional<List<String>> getTranscriptIds() {
        return transcriptIds;
    }

    /**
     * @return Custom formatted transcript data. Maximum size is the context limit of the selected model, which defaults to 100000.
     * Use either transcript_ids or input_text as input into LeMUR.
     */
    @JsonProperty("input_text")
    @java.lang.Override
    public Optional<String> getInputText() {
        return inputText;
    }

    /**
     * @return Context to provide the model. This can be a string or a free-form JSON value.
     */
    @JsonProperty("context")
    @java.lang.Override
    public Optional<LemurBaseParamsContext> getContext() {
        return context;
    }

    /**
     * @return The model that is used for the final prompt after compression is performed.
     * Defaults to &quot;default&quot;.
     */
    @JsonProperty("final_model")
    @java.lang.Override
    public Optional<LemurModel> getFinalModel() {
        return finalModel;
    }

    /**
     * @return Max output size in tokens, up to 4000
     */
    @JsonProperty("max_output_size")
    @java.lang.Override
    public Optional<Integer> getMaxOutputSize() {
        return maxOutputSize;
    }

    /**
     * @return The temperature to use for the model.
     * Higher values result in answers that are more creative, lower values are more conservative.
     * Can be any value between 0.0 and 1.0 inclusive.
     */
    @JsonProperty("temperature")
    @java.lang.Override
    public Optional<Double> getTemperature() {
        return temperature;
    }

    /**
     * @return Your text to prompt the model to produce a desired output, including any context you want to pass into the model.
     */
    @JsonProperty("prompt")
    public String getPrompt() {
        return prompt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LemurTaskParams && equalTo((LemurTaskParams) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LemurTaskParams other) {
        return transcriptIds.equals(other.transcriptIds)
                && inputText.equals(other.inputText)
                && context.equals(other.context)
                && finalModel.equals(other.finalModel)
                && maxOutputSize.equals(other.maxOutputSize)
                && temperature.equals(other.temperature)
                && prompt.equals(other.prompt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.transcriptIds,
                this.inputText,
                this.context,
                this.finalModel,
                this.maxOutputSize,
                this.temperature,
                this.prompt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PromptStage builder() {
        return new Builder();
    }

    public interface PromptStage {
        _FinalStage prompt(String prompt);

        Builder from(LemurTaskParams other);
    }

    public interface _FinalStage {
        LemurTaskParams build();

        _FinalStage transcriptIds(Optional<List<String>> transcriptIds);

        _FinalStage transcriptIds(List<String> transcriptIds);

        _FinalStage inputText(Optional<String> inputText);

        _FinalStage inputText(String inputText);

        _FinalStage context(Optional<LemurBaseParamsContext> context);

        _FinalStage context(LemurBaseParamsContext context);

        _FinalStage finalModel(Optional<LemurModel> finalModel);

        _FinalStage finalModel(LemurModel finalModel);

        _FinalStage maxOutputSize(Optional<Integer> maxOutputSize);

        _FinalStage maxOutputSize(Integer maxOutputSize);

        _FinalStage temperature(Optional<Double> temperature);

        _FinalStage temperature(Double temperature);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PromptStage, _FinalStage {
        private String prompt;

        private Optional<Double> temperature = Optional.empty();

        private Optional<Integer> maxOutputSize = Optional.empty();

        private Optional<LemurModel> finalModel = Optional.empty();

        private Optional<LemurBaseParamsContext> context = Optional.empty();

        private Optional<String> inputText = Optional.empty();

        private Optional<List<String>> transcriptIds = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LemurTaskParams other) {
            transcriptIds(other.getTranscriptIds());
            inputText(other.getInputText());
            context(other.getContext());
            finalModel(other.getFinalModel());
            maxOutputSize(other.getMaxOutputSize());
            temperature(other.getTemperature());
            prompt(other.getPrompt());
            return this;
        }

        /**
         * <p>Your text to prompt the model to produce a desired output, including any context you want to pass into the model.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("prompt")
        public _FinalStage prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        /**
         * <p>The temperature to use for the model.
         * Higher values result in answers that are more creative, lower values are more conservative.
         * Can be any value between 0.0 and 1.0 inclusive.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage temperature(Double temperature) {
            this.temperature = Optional.of(temperature);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "temperature", nulls = Nulls.SKIP)
        public _FinalStage temperature(Optional<Double> temperature) {
            this.temperature = temperature;
            return this;
        }

        /**
         * <p>Max output size in tokens, up to 4000</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage maxOutputSize(Integer maxOutputSize) {
            this.maxOutputSize = Optional.of(maxOutputSize);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "max_output_size", nulls = Nulls.SKIP)
        public _FinalStage maxOutputSize(Optional<Integer> maxOutputSize) {
            this.maxOutputSize = maxOutputSize;
            return this;
        }

        /**
         * <p>The model that is used for the final prompt after compression is performed.
         * Defaults to &quot;default&quot;.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage finalModel(LemurModel finalModel) {
            this.finalModel = Optional.of(finalModel);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "final_model", nulls = Nulls.SKIP)
        public _FinalStage finalModel(Optional<LemurModel> finalModel) {
            this.finalModel = finalModel;
            return this;
        }

        /**
         * <p>Context to provide the model. This can be a string or a free-form JSON value.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage context(LemurBaseParamsContext context) {
            this.context = Optional.of(context);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "context", nulls = Nulls.SKIP)
        public _FinalStage context(Optional<LemurBaseParamsContext> context) {
            this.context = context;
            return this;
        }

        /**
         * <p>Custom formatted transcript data. Maximum size is the context limit of the selected model, which defaults to 100000.
         * Use either transcript_ids or input_text as input into LeMUR.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage inputText(String inputText) {
            this.inputText = Optional.of(inputText);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "input_text", nulls = Nulls.SKIP)
        public _FinalStage inputText(Optional<String> inputText) {
            this.inputText = inputText;
            return this;
        }

        /**
         * <p>A list of completed transcripts with text. Up to a maximum of 100 files or 100 hours, whichever is lower.
         * Use either transcript_ids or input_text as input into LeMUR.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage transcriptIds(List<String> transcriptIds) {
            this.transcriptIds = Optional.of(transcriptIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "transcript_ids", nulls = Nulls.SKIP)
        public _FinalStage transcriptIds(Optional<List<String>> transcriptIds) {
            this.transcriptIds = transcriptIds;
            return this;
        }

        @java.lang.Override
        public LemurTaskParams build() {
            return new LemurTaskParams(
                    transcriptIds,
                    inputText,
                    context,
                    finalModel,
                    maxOutputSize,
                    temperature,
                    prompt,
                    additionalProperties);
        }
    }
}
