/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.ui.list;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.LiveData;
import android.arch.paging.DataSource;
import android.arch.paging.LivePagedListBuilder;
import android.arch.paging.PagedList;
import android.content.Context;
import android.os.AsyncTask;
import com.ashokvarma.gander.internal.data.GanderDatabase;
import com.ashokvarma.gander.internal.data.HttpTransaction;
import com.ashokvarma.gander.internal.data.TransactionDao;

public class TransactionListViewModel
extends AndroidViewModel {
    private LiveData<PagedList<HttpTransaction>> mTransactions;
    private final TransactionDao mTransactionDao;
    private static final PagedList.Config config = new PagedList.Config.Builder().setPageSize(15).setInitialLoadSizeHint(30).setPrefetchDistance(10).setEnablePlaceholders(true).build();

    public TransactionListViewModel(Application application) {
        super(application);
        this.mTransactionDao = GanderDatabase.getInstance((Context)application).httpTransactionDao();
        DataSource.Factory<Integer, HttpTransaction> factory = this.mTransactionDao.getAllTransactions();
        this.mTransactions = new LivePagedListBuilder(factory, config).build();
    }

    LiveData<PagedList<HttpTransaction>> getTransactions(String key) {
        if (key == null || key.trim().length() == 0) {
            return this.mTransactions;
        }
        DataSource.Factory<Integer, HttpTransaction> factory = this.mTransactionDao.getAllTransactionsWith(key, 1);
        return new LivePagedListBuilder(factory, config).build();
    }

    public void deleteItem(HttpTransaction transaction) {
        new deleteAsyncTask(this.mTransactionDao).execute(new HttpTransaction[]{transaction});
    }

    void clearAll() {
        new clearAsyncTask(this.mTransactionDao).execute(new HttpTransaction[0]);
    }

    private static class clearAsyncTask
    extends AsyncTask<HttpTransaction, Void, Integer> {
        private final TransactionDao transactionDao;

        clearAsyncTask(TransactionDao transactionDao) {
            this.transactionDao = transactionDao;
        }

        protected Integer doInBackground(HttpTransaction ... params) {
            return this.transactionDao.clearAll();
        }
    }

    private static class deleteAsyncTask
    extends AsyncTask<HttpTransaction, Void, Integer> {
        private final TransactionDao transactionDao;

        deleteAsyncTask(TransactionDao transactionDao) {
            this.transactionDao = transactionDao;
        }

        protected Integer doInBackground(HttpTransaction ... params) {
            return this.transactionDao.deleteTransactions(params);
        }
    }
}

