/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.support.event;

import android.os.Handler;
import android.support.annotation.NonNull;
import com.ashokvarma.gander.internal.support.event.Callback;

public class Debouncer<V> {
    private final int mInterval;
    private final Callback<V> mCallback;
    private final Handler mHandler;

    public Debouncer(int intervalInMills, @NonNull Callback<V> callback) {
        this.mInterval = intervalInMills;
        this.mCallback = callback;
        this.mHandler = new Handler();
    }

    public void consume(V event) {
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.postDelayed(new Counter<V>(event, this.mCallback), (long)this.mInterval);
    }

    public static class Counter<T>
    implements Runnable {
        private final T mEvent;
        private final Callback<T> mCallback;

        Counter(T event, Callback<T> callback) {
            this.mEvent = event;
            this.mCallback = callback;
        }

        @Override
        public void run() {
            this.mCallback.onEmit(this.mEvent);
        }
    }
}

