/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.support;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.LongSparseArray;
import com.ashokvarma.gander.Gander;
import com.ashokvarma.gander.R;
import com.ashokvarma.gander.internal.data.HttpTransaction;
import com.ashokvarma.gander.internal.support.ClearTransactionsService;
import com.ashokvarma.gander.internal.support.GanderColorUtil;
import com.ashokvarma.gander.internal.ui.BaseGanderActivity;

public class NotificationHelper {
    private static final String CHANNEL_ID = "gander_notif";
    private static final int NOTIFICATION_ID = 1139;
    private static final int BUFFER_SIZE = 10;
    private static final LongSparseArray<HttpTransaction> TRANSACTION_BUFFER = new LongSparseArray();
    private static int TRANSACTION_COUNT;
    private final Context mContext;
    private final NotificationManager mNotificationManager;
    private final GanderColorUtil mColorUtil;

    public static synchronized void clearBuffer() {
        TRANSACTION_BUFFER.clear();
        TRANSACTION_COUNT = 0;
    }

    private static synchronized void addToBuffer(HttpTransaction transaction) {
        if (transaction.getStatus() == HttpTransaction.Status.Requested) {
            ++TRANSACTION_COUNT;
        }
        TRANSACTION_BUFFER.put(transaction.getId(), (Object)transaction);
        if (TRANSACTION_BUFFER.size() > 10) {
            TRANSACTION_BUFFER.removeAt(0);
        }
    }

    public NotificationHelper(Context context) {
        this.mContext = context;
        this.mNotificationManager = (NotificationManager)context.getSystemService("notification");
        this.mColorUtil = GanderColorUtil.getInstance(context);
    }

    public void setUpChannelIfNecessary() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.mNotificationManager.createNotificationChannel(new NotificationChannel(CHANNEL_ID, (CharSequence)this.mContext.getString(R.string.gander_notification_category), 2));
        }
    }

    public synchronized void show(HttpTransaction transaction) {
        NotificationHelper.addToBuffer(transaction);
        if (!BaseGanderActivity.isInForeground()) {
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.mContext, CHANNEL_ID).setContentIntent(PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)Gander.getLaunchIntent(this.mContext), (int)0)).setLocalOnly(true).setSmallIcon(R.drawable.gander_ic_notification_white_24dp).setColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.gander_colorPrimary)).setContentTitle((CharSequence)this.mContext.getString(R.string.gander_notification_title));
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            int count = 0;
            for (int i = TRANSACTION_BUFFER.size() - 1; i >= 0; --i) {
                if (count < 10) {
                    if (count == 0) {
                        builder.setContentText(this.getNotificationText((HttpTransaction)TRANSACTION_BUFFER.valueAt(i)));
                    }
                    inboxStyle.addLine(this.getNotificationText((HttpTransaction)TRANSACTION_BUFFER.valueAt(i)));
                }
                ++count;
            }
            builder.setAutoCancel(true);
            builder.setStyle((NotificationCompat.Style)inboxStyle);
            if (Build.VERSION.SDK_INT >= 24) {
                builder.setSubText((CharSequence)String.valueOf(TRANSACTION_COUNT));
            } else {
                builder.setNumber(TRANSACTION_COUNT);
            }
            builder.addAction(this.getClearAction());
            this.mNotificationManager.notify(1139, builder.build());
        }
    }

    private CharSequence getNotificationText(HttpTransaction transaction) {
        int color2 = this.mColorUtil.getTransactionColor(transaction);
        String text = transaction.getNotificationText();
        SpannableString spannableString = new SpannableString((CharSequence)text);
        spannableString.setSpan((Object)new ForegroundColorSpan(color2), 0, text.length(), 17);
        return spannableString;
    }

    @NonNull
    private NotificationCompat.Action getClearAction() {
        String clearTitle = this.mContext.getString(R.string.gander_clear);
        Intent deleteIntent = new Intent(this.mContext, ClearTransactionsService.class);
        PendingIntent intent = PendingIntent.getService((Context)this.mContext, (int)11, (Intent)deleteIntent, (int)0x40000000);
        return new NotificationCompat.Action(R.drawable.gander_ic_delete_white_24dp, (CharSequence)clearTitle, intent);
    }

    public void dismiss() {
        this.mNotificationManager.cancel(1139);
    }
}

