/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander;

import android.content.Context;
import android.support.annotation.NonNull;
import com.ashokvarma.gander.R;
import com.ashokvarma.gander.internal.data.GanderDatabase;
import com.ashokvarma.gander.internal.data.HttpHeader;
import com.ashokvarma.gander.internal.data.HttpTransaction;
import com.ashokvarma.gander.internal.support.Logger;
import com.ashokvarma.gander.internal.support.NotificationHelper;
import com.ashokvarma.gander.internal.support.RetentionManager;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;

public class GanderInterceptor
implements Interceptor {
    private static final Period DEFAULT_RETENTION = Period.ONE_WEEK;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Context mContext;
    private final GanderDatabase mGanderDatabase;
    private final NotificationHelper mNotificationHelper;
    private RetentionManager mRetentionManager;
    private boolean mShowNotification;
    private long mMaxContentLength = 250000L;

    public GanderInterceptor(Context context, boolean showNotification) {
        this.mContext = context.getApplicationContext();
        this.mGanderDatabase = GanderDatabase.getInstance(context);
        this.mNotificationHelper = new NotificationHelper(this.mContext);
        this.mRetentionManager = new RetentionManager(this.mContext, DEFAULT_RETENTION);
        this.showNotification(showNotification);
    }

    public GanderInterceptor maxContentLength(long max) {
        this.mMaxContentLength = Math.min(max, 999999L);
        return this;
    }

    public GanderInterceptor retainDataFor(Period period) {
        this.mRetentionManager = new RetentionManager(this.mContext, period);
        return this;
    }

    private void showNotification(boolean show) {
        this.mShowNotification = show;
        if (this.mShowNotification) {
            this.mNotificationHelper.setUpChannelIfNecessary();
        }
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpTransaction transaction = this.createTransactionFromRequest(request);
        long startNs = System.nanoTime();
        try {
            Response response = chain.proceed(request);
            long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            this.updateTransactionFromResponse(transaction, response, tookMs);
            return response;
        }
        catch (Exception e) {
            transaction.setError(e.toString());
            this.update(transaction);
            throw e;
        }
    }

    @NonNull
    private HttpTransaction createTransactionFromRequest(Request request) throws IOException {
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        HttpTransaction transaction = new HttpTransaction();
        transaction.setRequestDate(new Date());
        transaction.setMethod(request.method());
        transaction.setUrlHostPathSchemeFromUrl(request.url().toString());
        transaction.setRequestHeaders(this.toHttpHeaderList(request.headers()));
        if (hasRequestBody) {
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                transaction.setRequestContentType(contentType.toString());
            }
            if (requestBody.contentLength() != -1L) {
                transaction.setRequestContentLength(requestBody.contentLength());
            }
        }
        transaction.setRequestBodyIsPlainText(this.bodyHasSupportedEncoding(request.headers()));
        if (hasRequestBody && transaction.requestBodyIsPlainText()) {
            BufferedSource source = this.getNativeSource((BufferedSource)new Buffer(), this.bodyGzipped(request.headers()));
            Buffer buffer = source.buffer();
            requestBody.writeTo((BufferedSink)buffer);
            Charset charset = UTF8;
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                charset = contentType.charset(UTF8);
            }
            if (this.isPlaintext(buffer)) {
                transaction.setRequestBody(this.readFromBuffer(buffer, charset));
            } else {
                transaction.setResponseBodyIsPlainText(false);
            }
        }
        return this.create(transaction);
    }

    private void updateTransactionFromResponse(HttpTransaction transaction, Response response, long tookMs) throws IOException {
        ResponseBody responseBody = response.body();
        if (response.cacheResponse() != null) {
            transaction.setResponseDate(new Date());
            transaction.setTookMs(tookMs);
        } else {
            transaction.setTookMs(response.receivedResponseAtMillis() - response.sentRequestAtMillis());
            transaction.setRequestDate(new Date(response.sentRequestAtMillis()));
            transaction.setResponseDate(new Date(response.receivedResponseAtMillis()));
        }
        transaction.setRequestHeaders(this.toHttpHeaderList(response.request().headers()));
        transaction.setProtocol(response.protocol().toString());
        transaction.setResponseCode(response.code());
        transaction.setResponseMessage(response.message());
        if (responseBody != null) {
            transaction.setResponseContentLength(responseBody.contentLength());
            MediaType contentType = responseBody.contentType();
            if (contentType != null) {
                transaction.setResponseContentType(contentType.toString());
            }
        }
        transaction.setResponseHeaders(this.toHttpHeaderList(response.headers()));
        transaction.setResponseBodyIsPlainText(this.bodyHasSupportedEncoding(response.headers()));
        if (HttpHeaders.hasBody((Response)response) && transaction.responseBodyIsPlainText()) {
            BufferedSource source = this.getNativeSource(response);
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = UTF8;
            MediaType contentType = null;
            if (responseBody != null) {
                contentType = responseBody.contentType();
            }
            if (contentType != null) {
                try {
                    charset = contentType.charset(UTF8);
                }
                catch (UnsupportedCharsetException e) {
                    this.update(transaction);
                    return;
                }
            }
            if (this.isPlaintext(buffer)) {
                transaction.setResponseBody(this.readFromBuffer(buffer.clone(), charset));
            } else {
                transaction.setResponseBodyIsPlainText(false);
            }
            transaction.setResponseContentLength(buffer.size());
        }
        this.update(transaction);
    }

    private HttpTransaction create(HttpTransaction transaction) {
        long transactionId = this.mGanderDatabase.httpTransactionDao().insertTransaction(transaction);
        transaction.setId(transactionId);
        if (this.mShowNotification) {
            this.mNotificationHelper.show(transaction);
        }
        this.mRetentionManager.doMaintenance();
        return transaction;
    }

    private void update(HttpTransaction transaction) {
        int updatedTransactionCount = this.mGanderDatabase.httpTransactionDao().updateTransaction(transaction);
        if (this.mShowNotification && updatedTransactionCount > 0) {
            this.mNotificationHelper.show(transaction);
        }
    }

    private boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    private boolean bodyHasSupportedEncoding(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding == null || contentEncoding.equalsIgnoreCase("identity") || contentEncoding.equalsIgnoreCase("gzip");
    }

    private boolean bodyGzipped(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return "gzip".equalsIgnoreCase(contentEncoding);
    }

    private String readFromBuffer(Buffer buffer, Charset charset) {
        long bufferSize = buffer.size();
        long maxBytes = Math.min(bufferSize, this.mMaxContentLength);
        String body = "";
        try {
            body = buffer.readString(maxBytes, charset);
        }
        catch (EOFException e) {
            body = body + this.mContext.getString(R.string.gander_body_unexpected_eof);
        }
        if (bufferSize > this.mMaxContentLength) {
            body = body + this.mContext.getString(R.string.gander_body_content_truncated);
        }
        return body;
    }

    private BufferedSource getNativeSource(BufferedSource input, boolean isGzipped) {
        if (isGzipped) {
            GzipSource source = new GzipSource((Source)input);
            return Okio.buffer((Source)source);
        }
        return input;
    }

    private BufferedSource getNativeSource(Response response) throws IOException {
        if (this.bodyGzipped(response.headers())) {
            BufferedSource source = response.peekBody(this.mMaxContentLength).source();
            if (source.buffer().size() < this.mMaxContentLength) {
                return this.getNativeSource(source, true);
            }
            Logger.w("gzip encoded response was too long");
        }
        return response.body().source();
    }

    private List<HttpHeader> toHttpHeaderList(Headers headers) {
        ArrayList<HttpHeader> httpHeaders = new ArrayList<HttpHeader>();
        int count = headers.size();
        for (int i = 0; i < count; ++i) {
            httpHeaders.add(new HttpHeader(headers.name(i), headers.value(i)));
        }
        return httpHeaders;
    }

    public static enum Period {
        ONE_HOUR,
        ONE_DAY,
        ONE_WEEK,
        FOREVER;

    }
}

