/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.crypto;

import com.arxanfintech.common.util.ByteUtils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class Hash {
    public static final Hash INVALID = Hash.createFromSafeArray(new byte[32]);
    private final byte[] bytes;

    public Hash(byte[] hash) {
        if (hash.length != 32) {
            throw new IllegalArgumentException("Digest length must be 32 bytes for Hash");
        }
        this.bytes = new byte[32];
        System.arraycopy(hash, 0, this.bytes, 0, 32);
    }

    public Hash(String hex) {
        if (hex.length() != 64) {
            throw new IllegalArgumentException("Digest length must be 64 hex characters for Hash");
        }
        this.bytes = ByteUtils.reverse(ByteUtils.fromHex(hex));
    }

    protected Hash(byte[] hash, boolean safe) {
        this.bytes = hash;
    }

    public byte[] unsafeGetArray() {
        return this.bytes;
    }

    public static Hash createFromSafeArray(byte[] hash) {
        if (hash.length != 32) {
            throw new IllegalArgumentException("Digest length must be 32 bytes for Hash");
        }
        return new Hash(hash, true);
    }

    public static Hash merge(Hash a, Hash b) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(a.bytes);
            return Hash.createFromSafeArray(digest.digest(digest.digest(b.bytes)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] hash(byte[] data, int offset, int len) {
        try {
            MessageDigest a = MessageDigest.getInstance("SHA-256");
            a.update(data, offset, len);
            return a.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] hash(byte[] data) {
        return Hash.hash(data, 0, data.length);
    }

    public static Hash of(byte[] data) {
        return new Hash(Hash.hash(data, 0, data.length));
    }

    public String toUuidString() {
        Object[] items = new String[]{this.contentAsHex(0, 4), this.contentAsHex(4, 6), this.contentAsHex(6, 8), this.contentAsHex(8, 10), this.contentAsHex(10, 16)};
        String result = StringUtils.join((Object[])items, (String)"-");
        return result.toLowerCase();
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, ByteUtils.reverse(this.toByteArray()));
    }

    public String toString() {
        return ByteUtils.toHex(this.toByteArray());
    }

    public int hashCode() {
        return (((this.bytes[0] & 0xFF) << 8 | this.bytes[1] & 0xFF) << 8 | this.bytes[2] & 0xFF) << 8 | this.bytes[3] & 0xFF;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hash hash = (Hash)o;
        return Arrays.equals(this.bytes, hash.bytes);
    }

    private String contentAsHex(int i, int j) {
        return ByteUtils.toHex(Arrays.copyOfRange(this.bytes, i, j));
    }
}

