/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.rest;

import com.arxanfintech.common.rest.Request;
import com.arxanfintech.common.structs.Headers;
import com.arxanfintech.common.util.Utils;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import java.io.File;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class Api {
    public CloseableHttpClient httpclient;

    public CloseableHttpClient NewHttpClient() throws Exception {
        if (this.httpclient == null) {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        return this.httpclient;
    }

    public String DoGet(Request request) throws Exception {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            Unirest.setHttpClient((HttpClient)httpclient);
            Map<String, String> mapHeader = Utils.JsonToMap(request.header);
            mapHeader.put(Headers.APIKeyHeader, request.client.GetApiKey());
            if (request.client.GetRouteTag() != "") {
                mapHeader.put(Headers.FabioRouteTagHeader, request.client.GetRouteTag());
                mapHeader.put(Headers.RouteTagHeader, request.client.GetRouteTag());
            }
            HttpResponse res = Unirest.get((String)request.url).headers(mapHeader).asString();
            String respData = (String)res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = "";
            oriData = request.client.GetEnableCrypto() != false ? request.crypto.decryptAndVerify(respData.getBytes()) : respData;
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public String DoPost(Request request) {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            Unirest.setHttpClient((HttpClient)httpclient);
            String buf = "";
            buf = request.client.GetEnableCrypto() != false ? request.crypto.signAndEncrypt(request.body.toString().getBytes()) : request.body.toString();
            Map<String, String> mapHeader = Utils.JsonToMap(request.header);
            mapHeader.put(Headers.APIKeyHeader, request.client.GetApiKey());
            if (request.client.GetRouteTag() != "") {
                mapHeader.put(Headers.FabioRouteTagHeader, request.client.GetRouteTag());
                mapHeader.put(Headers.RouteTagHeader, request.client.GetRouteTag());
            }
            System.out.println("after sign and encrypt : " + buf);
            HttpResponse res = Unirest.post((String)request.url).headers(mapHeader).body(buf).asString();
            String respData = (String)res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = "";
            oriData = request.client.GetEnableCrypto() != false ? request.crypto.decryptAndVerify(respData.getBytes()) : respData;
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }

    public String DoPut(Request request) {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            Unirest.setHttpClient((HttpClient)httpclient);
            String buf = "";
            buf = request.client.GetEnableCrypto() != false ? request.crypto.signAndEncrypt(request.body.toString().getBytes()) : request.body.toString();
            Map<String, String> mapHeader = Utils.JsonToMap(request.header);
            mapHeader.put(Headers.APIKeyHeader, request.client.GetApiKey());
            if (request.client.GetRouteTag() != "") {
                mapHeader.put(Headers.FabioRouteTagHeader, request.client.GetRouteTag());
                mapHeader.put(Headers.RouteTagHeader, request.client.GetRouteTag());
            }
            HttpResponse res = Unirest.put((String)request.url).headers(mapHeader).body(buf).asString();
            String respData = (String)res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = "";
            oriData = request.client.GetEnableCrypto() != false ? request.crypto.decryptAndVerify(respData.getBytes()) : respData;
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }

    public String DoUploadFile(Request request, String filename, String poeid, Boolean readonly) {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            Unirest.setHttpClient((HttpClient)httpclient);
            String buf = "";
            buf = request.client.GetEnableCrypto() != false ? request.crypto.signAndEncrypt(request.body.toString().getBytes()) : request.body.toString();
            Map<String, String> mapHeader = Utils.JsonToMap(request.header);
            mapHeader.put(Headers.APIKeyHeader, request.client.GetApiKey());
            if (request.client.GetRouteTag() != "") {
                mapHeader.put(Headers.FabioRouteTagHeader, request.client.GetRouteTag());
                mapHeader.put(Headers.RouteTagHeader, request.client.GetRouteTag());
            }
            HttpResponse res = Unirest.post((String)request.url).headers(mapHeader).field("poe_id", (Object)poeid).field("read_only", (Object)readonly).field("poe_file", filename).field("file", new File(filename)).asString();
            String respData = (String)res.getBody();
            System.out.println("Got remote cipher response: " + respData);
            String oriData = "";
            oriData = request.client.GetEnableCrypto() != false ? request.crypto.decryptAndVerify(respData.getBytes()) : respData;
            return oriData;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return "";
        }
    }
}

